/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredPreparedStatement;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.drda.DRDAResultSet;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.impl.drda.FdocaConstants;
import org.apache.derby.impl.jdbc.EmbedParameterSetMetaData;
import org.apache.derby.impl.jdbc.Util;

class DRDAStatement {
    protected String typDefNam;
    protected int byteOrder;
    protected int ccsidSBC;
    protected int ccsidDBC;
    protected int ccsidMBC;
    protected String ccsidSBCEncoding;
    protected String ccsidDBCEncoding;
    protected String ccsidMBCEncoding;
    protected Database database;
    private String pkgnamcsn;
    protected String pkgcnstknStr;
    protected String pkgid;
    protected String sectionNumber;
    protected int withHoldCursor = -1;
    protected int isolationLevel;
    protected String cursorName;
    protected int scrollType = 1003;
    protected int concurType = 1007;
    protected long rowCount;
    protected byte[] rslsetflg;
    protected int maxrslcnt;
    protected PreparedStatement ps;
    protected EmbedParameterSetMetaData stmtPmeta;
    protected boolean isCall;
    protected String procName;
    private int[] outputTypes;
    protected static int NOT_OUTPUT_PARAM = -100000;
    protected boolean outputExpected;
    private Statement stmt;
    private DRDAResultSet currentDrdaRs;
    private Hashtable resultSetTable;
    private ArrayList resultSetKeyList;
    private int numResultSets = 0;
    protected Vector cliParamDrdaTypes = new Vector();
    protected Vector cliParamLens = new Vector();
    protected ArrayList cliParamExtPositions = null;
    protected int nbrrow;
    protected int qryrowset;
    protected int blksize;
    protected int maxblkext;
    protected int outovropt;
    protected boolean qryrfrtbl;
    private int qryprctyp = 9239;
    boolean needsToSendParamData = false;
    boolean explicitlyPrepared = false;
    static /* synthetic */ Class class$java$lang$String;

    protected DRDAStatement(Database database) {
        this.database = database;
        this.setTypDefValues();
        this.currentDrdaRs = new DRDAResultSet();
    }

    protected void setTypDefValues() {
        this.typDefNam = this.database.typDefNam;
        this.byteOrder = this.database.byteOrder;
        this.ccsidSBC = this.database.ccsidSBC;
        this.ccsidDBC = this.database.ccsidDBC;
        this.ccsidMBC = this.database.ccsidMBC;
        this.ccsidSBCEncoding = this.database.ccsidSBCEncoding;
        this.ccsidDBCEncoding = this.database.ccsidDBCEncoding;
        this.ccsidMBCEncoding = this.database.ccsidMBCEncoding;
    }

    protected void setDatabase(Database database) {
        this.database = database;
        this.setTypDefValues();
    }

    protected void setStatement(Connection connection) throws SQLException {
        this.stmt = connection.createStatement();
        if (this.cursorName != null) {
            this.stmt.setCursorName(this.cursorName);
        }
    }

    protected Statement getStatement() throws SQLException {
        return this.stmt;
    }

    protected void setRsDefaultOptions(DRDAResultSet dRDAResultSet) {
        dRDAResultSet.nbrrow = this.nbrrow;
        dRDAResultSet.qryrowset = this.qryrowset;
        dRDAResultSet.blksize = this.blksize;
        dRDAResultSet.maxblkext = this.maxblkext;
        dRDAResultSet.outovropt = this.outovropt;
        dRDAResultSet.rslsetflg = this.rslsetflg;
        dRDAResultSet.scrollType = this.scrollType;
        dRDAResultSet.concurType = this.concurType;
        dRDAResultSet.setQryprctyp(this.qryprctyp);
        dRDAResultSet.qryrowset = this.qryrowset;
    }

    protected void setRsDefaultOptions() {
        this.setRsDefaultOptions(this.currentDrdaRs);
    }

    protected ArrayList getExtDtaObjects() {
        return this.currentDrdaRs.getExtDtaObjects();
    }

    protected void setExtDtaObjects(ArrayList arrayList) {
        this.currentDrdaRs.setExtDtaObjects(arrayList);
    }

    protected void addExtDtaObject(Object object, int n) {
        this.currentDrdaRs.addExtDtaObject(object, n);
    }

    protected void clearExtDtaObjects() {
        this.currentDrdaRs.clearExtDtaObjects();
    }

    protected int getResultSetHoldability() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = this.getResultSet();
        int n = -1;
        statement = resultSet != null ? resultSet.getStatement() : this.getPreparedStatement();
        Class[] classArray = new Class[]{};
        try {
            Method method = statement.getClass().getMethod("getResultSetHoldability", classArray);
            n = (Integer)method.invoke((Object)statement, null);
        }
        catch (Exception exception) {
            this.handleReflectionException(exception);
        }
        return n;
    }

    protected int getResultSetHoldability(ResultSet resultSet) throws SQLException {
        Statement statement = null;
        int n = -1;
        statement = resultSet != null ? resultSet.getStatement() : this.getPreparedStatement();
        Class[] classArray = new Class[]{};
        try {
            Method method = statement.getClass().getMethod("getResultSetHoldability", classArray);
            n = (Integer)method.invoke((Object)statement, null);
        }
        catch (Exception exception) {
            this.handleReflectionException(exception);
        }
        return n;
    }

    protected boolean isExtDtaValueNullable(int n) {
        return this.currentDrdaRs.isExtDtaValueNullable(n);
    }

    protected void setOPNQRYOptions(int n, int n2, int n3, int n4, int n5, int n6) {
        this.currentDrdaRs.setOPNQRYOptions(n, n2, n3, n4, n5, n6);
    }

    protected void setQueryOptions(int n, boolean bl, long l, boolean bl2, int n2, int n3, int n4, boolean bl3, boolean bl4, boolean bl5, int n5, int n6) {
        this.currentDrdaRs.blksize = n;
        this.currentDrdaRs.qryrelscr = bl;
        this.currentDrdaRs.qryrownbr = l;
        this.currentDrdaRs.qryrfrtbl = this.qryrfrtbl;
        this.currentDrdaRs.nbrrow = n2;
        this.currentDrdaRs.maxblkext = n3;
        this.currentDrdaRs.qryscrorn = n4;
        this.currentDrdaRs.qryrowsns = bl3;
        this.currentDrdaRs.qryblkrst = bl4;
        this.currentDrdaRs.qryrtndta = bl5;
        this.currentDrdaRs.qryrowset = n5;
        this.currentDrdaRs.rtnextdta = n6;
    }

    protected void setQryprctyp(int n) {
        this.qryprctyp = n;
        this.currentDrdaRs.setQryprctyp(n);
    }

    protected int getQryprctyp() throws SQLException {
        return this.currentDrdaRs.getQryprctyp();
    }

    protected void setQryrownbr(long l) {
        this.currentDrdaRs.qryrownbr = l;
    }

    protected long getQryrownbr() {
        return this.currentDrdaRs.qryrownbr;
    }

    protected int getQryrowset() {
        return this.currentDrdaRs.qryrowset;
    }

    protected int getBlksize() {
        return this.currentDrdaRs.blksize;
    }

    protected void setQryrtndta(boolean bl) {
        this.currentDrdaRs.qryrtndta = bl;
    }

    protected boolean getQryrtndta() {
        return this.currentDrdaRs.qryrtndta;
    }

    protected void setQryscrorn(int n) {
        this.currentDrdaRs.qryscrorn = n;
    }

    protected int getQryscrorn() {
        return this.currentDrdaRs.qryscrorn;
    }

    protected void setScrollType(int n) {
        this.currentDrdaRs.scrollType = n;
    }

    protected int getScrollType() {
        return this.currentDrdaRs.scrollType;
    }

    protected boolean isScrollable() {
        return this.getScrollType() != 1003;
    }

    protected void setConcurType(int n) {
        this.currentDrdaRs.concurType = n;
    }

    protected int getConcurType() {
        return this.currentDrdaRs.concurType;
    }

    protected void setOutovr_drdaType(int[] nArray) {
        this.currentDrdaRs.outovr_drdaType = nArray;
    }

    protected int[] getOutovr_drdaType() {
        return this.currentDrdaRs.outovr_drdaType;
    }

    protected boolean hasdata() {
        return this.currentDrdaRs.hasdata;
    }

    protected void setHasdata(boolean bl) {
        this.currentDrdaRs.hasdata = bl;
    }

    protected void initialize() {
        this.setTypDefValues();
    }

    protected PreparedStatement explicitPrepare(String string) throws SQLException {
        this.explicitlyPrepared = true;
        return this.prepare(string);
    }

    protected boolean wasExplicitlyPrepared() {
        return this.explicitlyPrepared;
    }

    protected PreparedStatement prepare(String string) throws SQLException {
        int n = -1;
        boolean bl = false;
        if (this.pkgnamcsn != null && this.isolationLevel != 0) {
            n = this.database.getPrepareIsolation();
            this.database.setPrepareIsolation(this.isolationLevel);
            bl = true;
        }
        if (this.isCallableSQL(string)) {
            this.isCall = true;
            this.ps = this.database.getConnection().prepareCall(string);
            this.setupCallableStatementParams((CallableStatement)this.ps);
            if (bl) {
                this.database.setPrepareIsolation(n);
            }
            return this.ps;
        }
        this.parsePkgidToFindHoldability();
        Connection connection = this.database.getConnection();
        this.ps = connection instanceof BrokeredConnection ? connection.prepareStatement(string, this.scrollType, this.concurType) : this.prepareStatementJDBC3(string, this.scrollType, this.concurType, this.withHoldCursor);
        if (this.cursorName != null) {
            this.ps.setCursorName(this.cursorName);
        }
        if (bl) {
            this.database.setPrepareIsolation(n);
        }
        return this.ps;
    }

    protected PreparedStatement getPreparedStatement() throws SQLException {
        if (this.ps instanceof BrokeredPreparedStatement) {
            return (PreparedStatement)((BrokeredPreparedStatement)this.ps).getStatement();
        }
        return this.ps;
    }

    protected boolean execute() throws SQLException {
        boolean bl = this.ps.execute();
        this.numResultSets = 0;
        ResultSet resultSet = null;
        boolean bl2 = this.ps instanceof CallableStatement;
        if (bl2) {
            this.needsToSendParamData = true;
        }
        do {
            if ((resultSet = this.ps.getResultSet()) == null) continue;
            if (bl2) {
                this.addResultSet(resultSet, this.getResultSetHoldability(resultSet));
            } else {
                this.addResultSet(resultSet, this.withHoldCursor);
            }
            bl = true;
        } while (bl2 && this.getMoreResults(2));
        return bl;
    }

    protected void finishParams() {
        this.needsToSendParamData = false;
    }

    protected void setPkgnamcsn(String string) {
        this.pkgnamcsn = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        this.pkgid = stringTokenizer.nextToken();
        if (this.isDynamicPkgid(this.pkgid)) {
            this.isolationLevel = Integer.parseInt(this.pkgid.substring(5, 6));
            String string2 = this.pkgid.substring(this.pkgid.length() - 5, this.pkgid.length());
            this.sectionNumber = stringTokenizer.nextToken();
            this.cursorName = "SQL_CUR" + string2 + "C" + this.sectionNumber;
        } else {
            this.isolationLevel = this.getStaticPackageIsolation(this.pkgid);
        }
        this.pkgcnstknStr = stringTokenizer.nextToken();
    }

    private int getStaticPackageIsolation(String string) {
        if (string.equals("SYSSTAT")) {
            return 1;
        }
        return 0;
    }

    protected String getPkgnamcsn() {
        return this.pkgnamcsn;
    }

    protected ResultSet getResultSet() {
        return this.currentDrdaRs.getResultSet();
    }

    private ResultSet getResultSet(int n) {
        if (n == 0) {
            return this.currentDrdaRs.getResultSet();
        }
        String string = (String)this.resultSetKeyList.get(n);
        return ((DRDAResultSet)this.resultSetTable.get(string)).getResultSet();
    }

    protected void setResultSet(ResultSet resultSet) throws SQLException {
        if (this.currentDrdaRs.getResultSet() == null) {
            this.numResultSets = 1;
        }
        this.currentDrdaRs.setResultSet(resultSet);
        this.setRsDefaultOptions(this.currentDrdaRs);
    }

    protected DRDAResultSet getCurrentDrdaResultSet() {
        return this.currentDrdaRs;
    }

    protected void setCurrentDrdaResultSet(int n) {
        String string = this.getResultSetPkgcnstknStr(n);
        if (this.currentDrdaRs.pkgcnstknStr == string) {
            return;
        }
        this.currentDrdaRs = this.getDrdaResultSet(string);
    }

    protected void setCurrentDrdaResultSet(String string) {
        String string2 = this.extractPkgcnstknStr(string);
        DRDAResultSet dRDAResultSet = this.getDrdaResultSet(string2);
        if (dRDAResultSet != null) {
            this.currentDrdaRs = dRDAResultSet;
        }
    }

    private DRDAResultSet getDrdaResultSet(String string) {
        if (this.resultSetTable == null || this.currentDrdaRs != null && this.currentDrdaRs.pkgcnstknStr == string) {
            return this.currentDrdaRs;
        }
        return (DRDAResultSet)this.resultSetTable.get(string);
    }

    private DRDAResultSet getDrdaResultSet(int n) {
        String string = this.getResultSetPkgcnstknStr(n);
        return this.getDrdaResultSet(string);
    }

    private String extractPkgcnstknStr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        this.pkgid = stringTokenizer.nextToken();
        this.sectionNumber = stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    protected String addResultSet(ResultSet resultSet, int n) throws SQLException {
        DRDAResultSet dRDAResultSet = null;
        int n2 = this.numResultSets;
        String string = this.calculateResultSetPkgcnstknStr(n2);
        if (n2 == 0) {
            dRDAResultSet = this.currentDrdaRs;
        } else {
            dRDAResultSet = new DRDAResultSet();
            if (this.resultSetTable == null) {
                this.resultSetTable = new Hashtable();
                this.resultSetTable.put(this.pkgcnstknStr, this.currentDrdaRs);
                this.resultSetKeyList = new ArrayList();
                this.resultSetKeyList.add(0, this.pkgcnstknStr);
            }
            this.resultSetTable.put(string, dRDAResultSet);
            this.resultSetKeyList.add(n2, string);
        }
        dRDAResultSet.setResultSet(resultSet);
        dRDAResultSet.setPkgcnstknStr(string);
        dRDAResultSet.withHoldCursor = n;
        this.setRsDefaultOptions(dRDAResultSet);
        dRDAResultSet.suspend();
        ++this.numResultSets;
        return string;
    }

    protected int getNumResultSets() {
        return this.numResultSets;
    }

    protected String getResultSetPkgcnstknStr(int n) {
        if (n == 0) {
            return this.pkgcnstknStr;
        }
        return (String)this.resultSetKeyList.get(n);
    }

    protected void setRsDRDATypes(int[] nArray) {
        this.currentDrdaRs.setRsDRDATypes(nArray);
    }

    protected int[] getRsDRDATypes() {
        return this.currentDrdaRs.getRsDRDATypes();
    }

    protected void setRsLens(int[] nArray) {
        this.currentDrdaRs.rsLens = nArray;
    }

    protected int[] getRsLens() {
        return this.currentDrdaRs.rsLens;
    }

    protected void rsClose() throws SQLException {
        if (this.currentDrdaRs.getResultSet() == null) {
            return;
        }
        this.currentDrdaRs.close();
        this.needsToSendParamData = false;
        --this.numResultSets;
    }

    protected void CLSQRY() {
        this.currentDrdaRs.CLSQRY();
    }

    protected boolean wasExplicitlyClosed() {
        return this.currentDrdaRs.wasExplicitlyClosed();
    }

    protected void close() throws SQLException {
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.rsClose();
        this.resultSetTable = null;
        this.resultSetKeyList = null;
        this.numResultSets = 0;
        this.ps = null;
        this.stmtPmeta = null;
        this.stmt = null;
        this.scrollType = 1003;
        this.concurType = 1007;
        this.withHoldCursor = -1;
        this.rowCount = 0L;
        this.rslsetflg = null;
        this.maxrslcnt = 0;
        this.procName = null;
        this.outputTypes = null;
        this.outputExpected = false;
        this.isCall = false;
        this.explicitlyPrepared = false;
        this.cliParamDrdaTypes = null;
        this.cliParamLens = null;
        this.cliParamExtPositions = null;
    }

    protected boolean rsIsClosed() {
        return this.currentDrdaRs.isClosed();
    }

    protected void rsSuspend() {
        this.currentDrdaRs.suspend();
    }

    protected void setRsPrecision(int n, int n2) {
        this.currentDrdaRs.setRsPrecision(n, n2);
    }

    protected int getRsPrecision(int n) {
        return this.currentDrdaRs.getRsPrecision(n);
    }

    protected void setRsScale(int n, int n2) {
        this.currentDrdaRs.setRsScale(n, n2);
    }

    protected int getRsScale(int n) {
        return this.currentDrdaRs.getRsScale(n);
    }

    protected void setRsDRDAType(int n, int n2) {
        this.currentDrdaRs.setRsDRDAType(n, n2);
    }

    protected int getParamDRDAType(int n) {
        return ((Byte)this.cliParamDrdaTypes.get(n - 1)).intValue();
    }

    protected void setParamDRDAType(int n, byte by) {
        this.cliParamDrdaTypes.addElement(new Byte(by));
    }

    protected int getParamLen(int n) {
        return (Integer)this.cliParamLens.elementAt(n - 1);
    }

    protected int getParamPrecision(int n) throws SQLException {
        if (this.ps != null && this.ps instanceof CallableStatement) {
            EmbedParameterSetMetaData embedParameterSetMetaData = this.getParameterMetaData();
            return Math.min(embedParameterSetMetaData.getPrecision(n), FdocaConstants.NUMERIC_MAX_PRECISION);
        }
        return -1;
    }

    protected int getParamScale(int n) throws SQLException {
        if (this.ps != null && this.ps instanceof CallableStatement) {
            EmbedParameterSetMetaData embedParameterSetMetaData = this.getParameterMetaData();
            return Math.min(embedParameterSetMetaData.getScale(n), FdocaConstants.NUMERIC_MAX_PRECISION);
        }
        return -1;
    }

    protected void setParamLen(int n, int n2) {
        this.cliParamLens.add(n - 1, new Integer(n2));
    }

    protected int getNumParams() {
        if (this.cliParamDrdaTypes != null) {
            return this.cliParamDrdaTypes.size();
        }
        return 0;
    }

    protected int getNumRsCols() {
        int[] nArray = this.currentDrdaRs.getRsDRDATypes();
        if (nArray != null) {
            return nArray.length;
        }
        return 0;
    }

    protected int getRsDRDAType(int n) {
        return this.currentDrdaRs.getRsDRDAType(n);
    }

    protected int getRsLen(int n) {
        return this.currentDrdaRs.getRsLen(n);
    }

    protected void setRsLen(int n, int n2) {
        this.currentDrdaRs.setRsLen(n, n2);
    }

    public boolean isProcedure() {
        return this.procName != null;
    }

    public String getResultSetCursorName(int n) throws SQLException {
        ResultSet resultSet = this.getResultSet(n);
        return resultSet.getCursorName();
    }

    protected String toDebugString(String string) {
        ResultSet resultSet = this.currentDrdaRs.getResultSet();
        String string2 = "";
        if (this.ps == null) {
            string2 = string2 + string + this.ps;
        } else {
            string2 = string2 + string + this.pkgid + this.sectionNumber;
            string2 = string2 + "\t" + this.getSQLText();
        }
        return string2;
    }

    protected String calculateResultSetPkgcnstknStr(int n) {
        String string = this.pkgcnstknStr;
        if (n == 0 || this.pkgcnstknStr == null) {
            return string;
        }
        try {
            BigInteger bigInteger = new BigInteger(string.getBytes("UTF8"));
            BigInteger bigInteger2 = BigInteger.valueOf(n);
            bigInteger = bigInteger.subtract(bigInteger2);
            string = new String(bigInteger.toByteArray(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    protected boolean isCallableStatement() {
        return this.isCall;
    }

    private boolean isCallableSQL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t\n\r\f=? (");
        String string2 = stringTokenizer.nextToken();
        return StringUtil.SQLEqualsIgnoreCase(string2, "call");
    }

    private void setupCallableStatementParams(CallableStatement callableStatement) throws SQLException {
        EmbedParameterSetMetaData embedParameterSetMetaData = this.getParameterMetaData();
        int n = embedParameterSetMetaData.getParameterCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            int n2 = embedParameterSetMetaData.getParameterMode(i + 1);
            int n3 = embedParameterSetMetaData.getParameterType(i + 1);
            switch (n2) {
                case 1: {
                    break;
                }
                case 2: 
                case 4: {
                    bl = true;
                    break;
                }
                case 0: {
                    String string = embedParameterSetMetaData.getParameterClassName(i + 1);
                    n3 = DRDAStatement.getOutputParameterTypeFromClassName(string);
                    if (n3 == NOT_OUTPUT_PARAM) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            if (this.outputTypes == null) {
                this.outputTypes = new int[n];
                for (int j = 0; j < n; ++j) {
                    this.outputTypes[j] = NOT_OUTPUT_PARAM;
                }
            }
            this.outputTypes[i] = n3;
        }
    }

    protected static int getOutputParameterTypeFromClassName(String string) {
        if (string.endsWith("[]")) {
            if (string.equals("byte[]")) {
                return NOT_OUTPUT_PARAM;
            }
            if (string.equals("java.lang.Byte[]")) {
                return -6;
            }
            if (string.equals("byte[][]")) {
                return -3;
            }
            if (string.equals("java.lang.String[]")) {
                return 12;
            }
            if (string.equals("int[]") || string.equals("java.lang.Integer[]")) {
                return 4;
            }
            if (string.equals("long[]") || string.equals("java.lang.Long[]")) {
                return -5;
            }
            if (string.equals("java.math.BigDecimal[]")) {
                return 2;
            }
            if (string.equals("boolean[]") || string.equals("java.lang.Boolean[]")) {
                return -7;
            }
            if (string.equals("short[]")) {
                return 5;
            }
            if (string.equals("float[]") || string.equals("java.lang.Float[]")) {
                return 7;
            }
            if (string.equals("double[]") || string.equals("java.lang.Double[]")) {
                return 8;
            }
            if (string.equals("java.sql.Date[]")) {
                return 91;
            }
            if (string.equals("java.sql.Time[]")) {
                return 92;
            }
            if (string.equals("java.sql.Timestamp[]")) {
                return 93;
            }
        }
        return NOT_OUTPUT_PARAM;
    }

    public void registerAllOutParams() throws SQLException {
        if (this.isCall && this.outputTypes != null) {
            for (int i = 1; i <= this.outputTypes.length; ++i) {
                this.registerOutParam(i);
            }
        }
    }

    public void registerOutParam(int n) throws SQLException {
        if (this.isOutputParam(n)) {
            CallableStatement callableStatement = (CallableStatement)this.ps;
            callableStatement.registerOutParameter(n, this.getOutputParamType(n));
        }
    }

    protected boolean hasOutputParams() {
        return this.outputTypes != null;
    }

    boolean isOutputParam(int n) {
        if (this.outputTypes != null) {
            return this.outputTypes[n - 1] != NOT_OUTPUT_PARAM;
        }
        return false;
    }

    int getOutputParamType(int n) {
        if (this.outputTypes != null) {
            return this.outputTypes[n - 1];
        }
        return NOT_OUTPUT_PARAM;
    }

    private boolean isDynamicPkgid(String string) {
        char c = string.charAt(3);
        char c2 = string.charAt(4);
        return !(!string.substring(0, 3).equals("SYS") || c != 'S' && c != 'L' || c2 != 'H' && c2 != 'N');
    }

    private void parsePkgidToFindHoldability() {
        if (this.withHoldCursor != -1) {
            return;
        }
        this.withHoldCursor = this.isDynamicPkgid(this.pkgid) ? (this.pkgid.charAt(4) == 'N' ? 2 : 1) : 1;
    }

    private PreparedStatement prepareStatementJDBC3(String string, int n, int n2, int n3) throws SQLException {
        int n4;
        PreparedStatement preparedStatement = null;
        n4 = n3 == -1 ? (n4 = 1) : n3;
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DRDAStatement.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(n4)};
        try {
            Method method = this.database.getConnection().getClass().getMethod("prepareStatement", classArray);
            preparedStatement = (PreparedStatement)method.invoke((Object)this.database.getConnection(), objectArray);
        }
        catch (Exception exception) {
            this.handleReflectionException(exception);
        }
        return preparedStatement;
    }

    protected EmbedParameterSetMetaData getParameterMetaData() throws SQLException {
        if (this.stmtPmeta != null) {
            return this.stmtPmeta;
        }
        EmbedParameterSetMetaData embedParameterSetMetaData = null;
        Class[] classArray = new Class[]{};
        try {
            Method method = this.getPreparedStatement().getClass().getMethod("getEmbedParameterSetMetaData", classArray);
            this.stmtPmeta = embedParameterSetMetaData = (EmbedParameterSetMetaData)method.invoke((Object)this.getPreparedStatement(), null);
        }
        catch (Exception exception) {
            this.handleReflectionException(exception);
        }
        return this.stmtPmeta;
    }

    protected boolean getMoreResults(int n) throws SQLException {
        boolean bl = false;
        Class[] classArray = new Class[]{Integer.TYPE};
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            Method method = this.getPreparedStatement().getClass().getMethod("getMoreResults", classArray);
            Boolean bl2 = (Boolean)method.invoke((Object)this.getPreparedStatement(), objectArray);
            bl = bl2;
        }
        catch (Exception exception) {
            this.handleReflectionException(exception);
        }
        return bl;
    }

    private String getSQLText() {
        String string = null;
        Class[] classArray = new Class[]{};
        Object[] objectArray = null;
        try {
            Method method = this.getPreparedStatement().getClass().getMethod("getSQLText", classArray);
            string = (String)method.invoke((Object)this.getPreparedStatement(), objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void handleReflectionException(Exception exception) throws SQLException {
        if (exception instanceof InvocationTargetException) {
            Throwable throwable = ((InvocationTargetException)exception).getTargetException();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            throwable.printStackTrace();
            throw Util.javaException(throwable);
        }
        throw Util.javaException(exception);
    }

    boolean isRSCloseImplicit() throws SQLException {
        return this.currentDrdaRs.isRSCloseImplicit();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

