<?php
require_once("./define.php");
Rhaco::import("network.http.RequestLogin");
Rhaco::import("tag.feed.Atom10");
Rhaco::import("tag.HtmlParser");
Rhaco::importLibrary("WorkStyle");
Rhaco::importLibrary("data.TaskQuery");

$request 	= new RequestLogin();
$workStyle	= new WorkStyle($request);
$feed		= new Atom10();
$parser		= new HtmlParser();

$feed->setTitle("WorkStyle");
$feed->addLink(Rhaco::url("TaskList.php?onStatus=2"));
$feed->addLink(Rhaco::url("util/atom.php"),"self","application/atom+xml");
$feed->setId(Rhaco::url("/TaskList.php"));
$feed->setAuthor("WorkStyle Rhaco");
$feed->setUpdated(DateUtil::formatAtom(time()));

$entryList = array();
foreach($workStyle->updateListTask($request->toObject(new TaskQuery())) as $task){
	$parser->setRequest(array("task"=>$task));
	
	$entry = new AtomEntry10();
	$entry->setTitle(sprintf("%s:%s",$task->getTaskId(),TagFormatter::text2Html($task->getContentsLine(1))));
	$entry->addLink(sprintf("%s?taskId=%s",Rhaco::url("taskDetail.php"),$task->getTaskId()));
	$entry->setId($task->getTaskId());
	$entry->setUpdated($task->getUpdateDate());
	$entry->setContent($parser->read("feed.html"));

	$entryList[] = $entry;
}
$feed->setEntryList($entryList);
$feed->write();
?>