<?php
require_once("./define.php");
Rhaco::import("network.http.RequestLogin");
Rhaco::import("network.http.Header");
Rhaco::importLibrary("WorkStyle");
Rhaco::importLibrary("data.TaskQuery");

$request 	= new RequestLogin();
$workStyle			= new WorkStyle($request);

if($request->isPost()){
	$task = $workStyle->getTask($request->getElement("taskId"));	
	$submit = false;

	if($task){
		switch($request->getElement("actionType")){
			case 1:
				$task->setStatusId($request->getElement("statusId"));
				$submit = $workStyle->updateTask($task);
				break;
			case 2:
				$submit = $workStyle->dropTask($request->getElement("taskId"));
				break;
			case 3:
				$submit = $workStyle->linkTask($request->getElement("taskId"),$request->getElement("relationTaskId"));
				$request->clearElement("relationTaskId");
				break;
		}
	}
	if($submit){
		Header::redirect(Rhaco::url("taskList.php"),$workStyle->query($request->getElements()));
	}
}
$taskResult = $workStyle->listTask($request->toObject(new TaskQuery()));
$request->setElement("pager",$taskResult->getPager());
$request->setElement("taskList",$taskResult->getList());

$request->setElement("tagMasterList",$workStyle->listTag());
$request->setElement("tagTypeList",$workStyle->listTagType());

$workStyle->template($request->getElements(),"TaskList.html");
?>