<?php
require_once("./define.php");
Rhaco::import("network.http.Header");
Rhaco::import("network.http.RequestLogin");
Rhaco::importLibrary("WorkStyle");

$request 	= new RequestLogin();
$workStyle	= new WorkStyle($request);

if($request->isPost()){
	$task	= $workStyle->getTask($request->getElement("taskId"));	
	$submit	= false;

	if($task){
		switch($request->getElement("actionType")){
			case 1:
				$task->setStatusId($request->getElement("statusId"));
				$submit = $workStyle->updateTask($task);
				break;
			case 2:
				$task->setTagList($request->getElement("tagList"));
				$submit = $workStyle->updateTask($task);
				break;
			case 3:
				$submit = $workStyle->insertFile(
							$request->getElement("taskId"),
							$request->getFile("attachFile")
							);
				break;
			case 4:
				$submit = $workStyle->dropFile(
							$request->getElement("taskId"),
							$request->getElement("fileId")
							);
				break;
			case 5:
				$taskCommnet = new TaskComment();
				$taskCommnet->setTaskId($request->getElement("taskId"));
				$taskCommnet->setContents($request->getElement("contents"));
				$taskCommnet->setCommentator($request->getElement("commentator"));
				if($workStyle->insertComment($taskCommnet)){
					$request->clearElement("commentator");
					$request->clearElement("contents");
					$submit = true;
				}
				break;
			case 6:
				$submit = $workStyle->dropLinkTask($request->getElement("taskId"),$request->getElement("relationTaskId"));
				break;
		}
	}
	if($submit){
		$query = $workStyle->query($request->getElements());
		$query["taskId"] = $request->getElement("taskId");
		Header::redirect(Rhaco::url("taskDetail.php"),$query);
	}
}
$task = $workStyle->getTask($request->getElement("taskId"));

if(empty($task)){
	Header::redirect(Rhaco::url("TaskList.php"),$request->getElements());
}
$request->setElement("task",$task);
$request->setElement("tagMasterList",$workStyle->listTag());
$request->setElement("tagTypeList",$workStyle->listTagType());

$workStyle->template($request->getElements(),"TaskDetail.html");
?>