<?php
require_once("./define.php");
Rhaco::import("network.http.Header");
Rhaco::import("network.http.RequestLogin");
Rhaco::importLibrary("WorkStyle");

$request 	= new RequestLogin();
$workStyle	= new WorkStyle($request);

if($request->isPost()){
	$tag		= $workStyle->getTag($request->getElement("tagId"));
	$submit	= false;

	if($tag){
		switch($request->getElement("actionType")){
			case 1:
				$tag->setTagTypeId($request->getElement("tagTypeId"));
				$submit = $workStyle->updateTag($tag);
				break;
			case 2:
				$submit = $workStyle->dropTag($tag);
				break;
			case 3:
				$submit = $tag->setActive($request->getElement("active"));	
				$workStyle->updateTag($tag);
				break;
		}
	}
	if($submit){
		Header::redirect(Rhaco::url("tagList.php"),$workStyle->query($request->getElements()));
	}
}
$request->setElement("tagMasterList",$workStyle->listTag());
$request->setElement("tagTypeList",$workStyle->listTagType());

$workStyle->template($request->getElements(),"TagList.html");
?>