<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class TaskRelationTableVerify{
	var $errorList = array();

	function TaskRelationTableVerify(){
	}
	function verify($tableObject){
		$this->verifySrcTaskId($tableObject->getSrcTaskId());
		$this->verifyDestTaskId($tableObject->getDestTaskId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				ExceptionTrigger::raise($exception);
			}
			return false;
		}
		return true;	
	}

	function verifySrcTaskId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedSrcTaskId()));
		}
		unset($value);
	}
	function verifyDestTaskId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedDestTaskId()));
		}
		unset($value);
	}

	function namedSrcTaskId(){
		return Message::_("SRC_TASK_ID");
	}
	function namedDestTaskId(){
		return Message::_("DEST_TASK_ID");
	}
}

?>