<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class TaskMasterTableVerify{
	var $errorList = array();

	function TaskMasterTableVerify(){
	}
	function verify($tableObject){
		$this->verifyTaskId($tableObject->getTaskId());
		$this->verifyContents($tableObject->getContents());
		$this->verifyEstimatedManHour($tableObject->getEstimatedManHour());
		$this->verifyTagList($tableObject->getTagList());
		$this->verifyUpdateDate($tableObject->getUpdateDate());
		$this->verifyRegistDate($tableObject->getRegistDate());
		$this->verifyCreator($tableObject->getCreator());
		$this->verifyStatusId($tableObject->getStatusId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				ExceptionTrigger::raise($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyTaskId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedTaskId()));
		}
		unset($value);
	}
	function verifyContents($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedContents()));
		}
		unset($value);
	}
	function verifyEstimatedManHour($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedEstimatedManHour()));
		}
		unset($value);
	}
	function verifyTagList($value){
		unset($value);
	}
	function verifyUpdateDate($value){
		if(!Validate::isTimestamp($value)){
			$this->errorList[] = new DataTypeException(array($this->namedUpdateDate()));
		}
		unset($value);
	}
	function verifyRegistDate($value){
		if(!Validate::isTimestamp($value)){
			$this->errorList[] = new DataTypeException(array($this->namedRegistDate()));
		}
		unset($value);
	}
	function verifyCreator($value){
		if(!Validate::isString($value,0,50)){
			$this->errorList[] = new MaxLengthException(array($this->namedCreator(),50));
		}
		unset($value);
	}
	function verifyStatusId($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedStatusId()));
		}
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedStatusId()));
		}
		unset($value);
	}

	function namedTaskId(){
		return Message::_("TASK_ID");
	}
	function namedContents(){
		return Message::_("CONTENTS");
	}
	function namedEstimatedManHour(){
		return Message::_("ESTIMATED_MAN_HOUR");
	}
	function namedTagList(){
		return Message::_("TAG_LIST");
	}
	function namedUpdateDate(){
		return Message::_("UPDATE_DATE");
	}
	function namedRegistDate(){
		return Message::_("REGIST_DATE");
	}
	function namedCreator(){
		return Message::_("CREATOR");
	}
	function namedStatusId(){
		return Message::_("STATUS_ID");
	}
}

?>