<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.verify.TaskMasterVerify");
Rhaco::importLibrary("data.TaskComment");
Rhaco::importLibrary("data.TaskRelation");
Rhaco::importLibrary("data.TaskFileRelation");
class TaskMasterTable extends TableObjectBase{
	var $taskId;
	var $contents;
	var $estimatedManHour;
	var $tagList;
	var $updateDate;
	var $registDate;
	var $creator;
	var $statusId;

	function TaskMasterTable(
		$taskId=null
	){
		$this->taskId = 0;
		$this->contents = null;
		$this->estimatedManHour = 0;
		$this->tagList = null;
		$this->updateDate = time();
		$this->registDate = time();
		$this->creator = null;
		$this->statusId = 3;
		$this->setTaskId($taskId);
	}

	function setTaskId($value){
		$this->taskId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getTaskId(){
		return $this->taskId;
	}
	function setContents($value){
		$this->contents = $value;
	}
	function getContents(){
		return $this->contents;
	}
	function setEstimatedManHour($value){
		$this->estimatedManHour = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getEstimatedManHour(){
		return $this->estimatedManHour;
	}
	function setTagList($value){
		$this->tagList = $value;
	}
	function getTagList(){
		return $this->tagList;
	}
	function setUpdateDate($value){
		if(!is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->updateDate = $value;
	}
	function getUpdateDate(){
		return $this->updateDate;
	}
	function formatUpdateDate($format="Y/m/d H:i:s"){
		return date($format,$this->updateDate);
	}
	function setRegistDate($value){
		if(!is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->registDate = $value;
	}
	function getRegistDate(){
		return $this->registDate;
	}
	function formatRegistDate($format="Y/m/d H:i:s"){
		return date($format,$this->registDate);
	}
	function setCreator($value){
		$this->creator = $value;
	}
	function getCreator(){
		return $this->creator;
	}
	function setStatusId($value){
		$this->statusId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getStatusId(){
		return $this->statusId;
	}
	
	function columnTaskId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK","TASK_MASTER"),"TASK_ID","TaskId","SERIAL");
	}
	function columnContents(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK","TASK_MASTER"),"CONTENTS","Contents","STRING");
	}
	function columnEstimatedManHour(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK","TASK_MASTER"),"ESTIMATED_MAN_HOUR","EstimatedManHour","INTEGER");
	}
	function columnTagList(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK","TASK_MASTER"),"TAG_LIST","TagList","STRING");
	}
	function columnUpdateDate(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK","TASK_MASTER"),"UPDATE_DATE","UpdateDate","TIMESTAMP");
	}
	function columnRegistDate(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK","TASK_MASTER"),"REGIST_DATE","RegistDate","TIMESTAMP");
	}
	function columnCreator(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK","TASK_MASTER"),"CREATOR","Creator","STRING");
	}
	function columnStatusId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK","TASK_MASTER"),"STATUS_ID","StatusId","INTEGER");
	}

	function __columns(){
		return array(
				$this->columnTaskId()
				,$this->columnContents()
				,$this->columnEstimatedManHour()
				,$this->columnTagList()
				,$this->columnUpdateDate()
				,$this->columnRegistDate()
				,$this->columnCreator()
				,$this->columnStatusId()
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnTaskId()
				);
	}


	function dependColumnTaskId(){
		$list	= array();
	
		$criteria = new Criteria();
		$criteria->add(TaskComment::columnTaskId(),$this->getTaskId());
		$list[] = array(new TaskComment(),$criteria);
	
		$criteria = new Criteria();
		$criteria->add(TaskRelation::columnSrcTaskId(),$this->getTaskId());
		$list[] = array(new TaskRelation(),$criteria);
	
		$criteria = new Criteria();
		$criteria->add(TaskRelation::columnDestTaskId(),$this->getTaskId());
		$list[] = array(new TaskRelation(),$criteria);
	
		$criteria = new Criteria();
		$criteria->add(TaskFileRelation::columnTaskId(),$this->getTaskId());
		$list[] = array(new TaskFileRelation(),$criteria);
		
		return $list;
	}

	function related($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		
		return $criteria;
	}
	function __verify(){
		$verify = new TaskMasterVerify();
		return $verify->verify($this);
	}
}
?>