<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class TaskFileRelationTableVerify{
	var $errorList = array();

	function TaskFileRelationTableVerify(){
	}
	function verify($tableObject){
		$this->verifyTaskId($tableObject->getTaskId());
		$this->verifyFileId($tableObject->getFileId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				ExceptionTrigger::raise($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyTaskId($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedTaskId()));
		}
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedTaskId()));
		}
		unset($value);
	}
	function verifyFileId($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedFileId()));
		}
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedFileId()));
		}
		unset($value);
	}

	function namedTaskId(){
		return Message::_("TASK_ID");
	}
	function namedFileId(){
		return Message::_("FILE_ID");
	}
}

?>