<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.verify.TaskFileRelationVerify");
Rhaco::importLibrary("data.TaskMaster");
Rhaco::importLibrary("data.FileInfo");
class TaskFileRelationTable extends TableObjectBase{
	var $taskId;
	var $fileId;

	function TaskFileRelationTable(
	){
		$this->taskId = 0;
		$this->fileId = 0;
	}

	function setTaskId($value){
		$this->taskId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getTaskId(){
		return $this->taskId;
	}
	function setFileId($value){
		$this->fileId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getFileId(){
		return $this->fileId;
	}
	
	function columnTaskId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK_FILE_RELATION","TASK_FILE_RELATION"),"TASK_ID","TaskId","INTEGER");
	}
	function columnFileId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK_FILE_RELATION","TASK_FILE_RELATION"),"FILE_ID","FileId","INTEGER");
	}

	function __columns(){
		return array(
				$this->columnTaskId()
				,$this->columnFileId()
				);
	}
	function __primaryKey(){
		return array(	
				);
	}

	function criteriaTaskId($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			TaskMaster::columnTaskId(),
			$this->getTaskId()
		);
		return $criteria;
	}
	function criteriaFileId($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			FileInfo::columnFileId(),
			$this->getFileId()
		);
		return $criteria;
	}


	function related($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			TaskMaster::columnTaskId(),
			TaskFileRelation::columnTaskId()
		);
		$criteria->add(
			FileInfo::columnFileId(),
			TaskFileRelation::columnFileId()
		);
		
		return $criteria;
	}
	function __verify(){
		$verify = new TaskFileRelationVerify();
		return $verify->verify($this);
	}
}
?>