<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class TaskCommentTableVerify{
	var $errorList = array();

	function TaskCommentTableVerify(){
	}
	function verify($tableObject){
		$this->verifyCommentId($tableObject->getCommentId());
		$this->verifyContents($tableObject->getContents());
		$this->verifyCommentator($tableObject->getCommentator());
		$this->verifyUpdateDate($tableObject->getUpdateDate());
		$this->verifyTaskId($tableObject->getTaskId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				ExceptionTrigger::raise($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyCommentId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedCommentId()));
		}
		unset($value);
	}
	function verifyContents($value){
		if(!Validate::isString($value,0,1000)){
			$this->errorList[] = new MaxLengthException(array($this->namedContents(),1000));
		}
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedContents()));
		}
		unset($value);
	}
	function verifyCommentator($value){
		if(!Validate::isString($value,0,50)){
			$this->errorList[] = new MaxLengthException(array($this->namedCommentator(),50));
		}
		unset($value);
	}
	function verifyUpdateDate($value){
		if(!Validate::isTimestamp($value)){
			$this->errorList[] = new DataTypeException(array($this->namedUpdateDate()));
		}
		unset($value);
	}
	function verifyTaskId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedTaskId()));
		}
		unset($value);
	}

	function namedCommentId(){
		return Message::_("COMMENT_ID");
	}
	function namedContents(){
		return Message::_("CONTENTS");
	}
	function namedCommentator(){
		return Message::_("COMMENTATOR");
	}
	function namedUpdateDate(){
		return Message::_("UPDATE_DATE");
	}
	function namedTaskId(){
		return Message::_("TASK_ID");
	}
}

?>