<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.verify.TaskCommentVerify");
Rhaco::importLibrary("data.TaskMaster");
class TaskCommentTable extends TableObjectBase{
	var $commentId;
	var $contents;
	var $commentator;
	var $updateDate;
	var $taskId;

	function TaskCommentTable(
		$commentId=null
	){
		$this->commentId = 0;
		$this->contents = null;
		$this->commentator = null;
		$this->updateDate = time();
		$this->taskId = 0;
		$this->setCommentId($commentId);
	}

	function setCommentId($value){
		$this->commentId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getCommentId(){
		return $this->commentId;
	}
	function setContents($value){
		$this->contents = $value;
	}
	function getContents(){
		return $this->contents;
	}
	function setCommentator($value){
		$this->commentator = $value;
	}
	function getCommentator(){
		return $this->commentator;
	}
	function setUpdateDate($value){
		if(!is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->updateDate = $value;
	}
	function getUpdateDate(){
		return $this->updateDate;
	}
	function formatUpdateDate($format="Y/m/d H:i:s"){
		return date($format,$this->updateDate);
	}
	function setTaskId($value){
		$this->taskId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getTaskId(){
		return $this->taskId;
	}
	
	function columnCommentId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK_COMMENT","TASK_COMMENT"),"COMMENT_ID","CommentId","SERIAL");
	}
	function columnContents(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK_COMMENT","TASK_COMMENT"),"CONTENTS","Contents","STRING");
	}
	function columnCommentator(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK_COMMENT","TASK_COMMENT"),"COMMENTATOR","Commentator","STRING");
	}
	function columnUpdateDate(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK_COMMENT","TASK_COMMENT"),"UPDATE_DATE","UpdateDate","TIMESTAMP");
	}
	function columnTaskId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TASK_COMMENT","TASK_COMMENT"),"TASK_ID","TaskId","INTEGER");
	}

	function __columns(){
		return array(
				$this->columnCommentId()
				,$this->columnContents()
				,$this->columnCommentator()
				,$this->columnUpdateDate()
				,$this->columnTaskId()
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnCommentId()
				);
	}

	function criteriaTaskId($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			TaskMaster::columnTaskId(),
			$this->getTaskId()
		);
		return $criteria;
	}


	function related($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			TaskMaster::columnTaskId(),
			TaskComment::columnTaskId()
		);
		
		return $criteria;
	}
	function __verify(){
		$verify = new TaskCommentVerify();
		return $verify->verify($this);
	}
}
?>