<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class TagTypeTableVerify{
	var $errorList = array();

	function TagTypeTableVerify(){
	}
	function verify($tableObject){
		$this->verifyTagTypeId($tableObject->getTagTypeId());
		$this->verifyName($tableObject->getName());
		$this->verifySortOrder($tableObject->getSortOrder());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				ExceptionTrigger::raise($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyTagTypeId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedTagTypeId()));
		}
		unset($value);
	}
	function verifyName($value){
		if(!Validate::isString($value,0,20)){
			$this->errorList[] = new MaxLengthException(array($this->namedName(),20));
		}
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedName()));
		}
		unset($value);
	}
	function verifySortOrder($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedSortOrder()));
		}
		unset($value);
	}

	function namedTagTypeId(){
		return Message::_("TAG_TYPE_ID");
	}
	function namedName(){
		return Message::_("NAME");
	}
	function namedSortOrder(){
		return Message::_("SORT_ORDER");
	}
}

?>