<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.verify.TagTypeVerify");
Rhaco::importLibrary("data.TagMaster");
class TagTypeTable extends TableObjectBase{
	var $tagTypeId;
	var $name;
	var $sortOrder;

	function TagTypeTable(
		$tagTypeId=null
	){
		$this->tagTypeId = 0;
		$this->name = null;
		$this->sortOrder = 0;
		$this->setTagTypeId($tagTypeId);
	}

	function setTagTypeId($value){
		$this->tagTypeId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getTagTypeId(){
		return $this->tagTypeId;
	}
	function setName($value){
		$this->name = $value;
	}
	function getName(){
		return $this->name;
	}
	function setSortOrder($value){
		$this->sortOrder = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getSortOrder(){
		return $this->sortOrder;
	}
	
	function columnTagTypeId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TAG_TYPE","TAG_TYPE"),"TAG_TYPE_ID","TagTypeId","SERIAL");
	}
	function columnName(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TAG_TYPE","TAG_TYPE"),"NAME","Name","STRING");
	}
	function columnSortOrder(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TAG_TYPE","TAG_TYPE"),"SORT_ORDER","SortOrder","INTEGER");
	}

	function __columns(){
		return array(
				$this->columnTagTypeId()
				,$this->columnName()
				,$this->columnSortOrder()
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnTagTypeId()
				);
	}


	function dependColumnTagTypeId(){
		$list	= array();
	
		$criteria = new Criteria();
		$criteria->add(TagMaster::columnTagTypeId(),$this->getTagTypeId());
		$list[] = array(new TagMaster(),$criteria);
		
		return $list;
	}

	function related($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		
		return $criteria;
	}
	function __verify(){
		$verify = new TagTypeVerify();
		return $verify->verify($this);
	}
}
?>