<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class TagMasterTableVerify{
	var $errorList = array();

	function TagMasterTableVerify(){
	}
	function verify($tableObject){
		$this->verifyTagId($tableObject->getTagId());
		$this->verifyName($tableObject->getName());
		$this->verifyActive($tableObject->getActive());
		$this->verifyTagTypeId($tableObject->getTagTypeId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				ExceptionTrigger::raise($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyTagId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedTagId()));
		}
		unset($value);
	}
	function verifyName($value){
		if(!Validate::isString($value,0,20)){
			$this->errorList[] = new MaxLengthException(array($this->namedName(),20));
		}
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedName()));
		}
		unset($value);
	}
	function verifyActive($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedActive()));
		}
		unset($value);
	}
	function verifyTagTypeId($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedTagTypeId()));
		}
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedTagTypeId()));
		}
		unset($value);
	}

	function namedTagId(){
		return Message::_("TAG_ID");
	}
	function namedName(){
		return Message::_("NAME");
	}
	function namedActive(){
		return Message::_("ACTIVE");
	}
	function namedTagTypeId(){
		return Message::_("TAG_TYPE_ID");
	}
}

?>