<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.verify.TagMasterVerify");
Rhaco::importLibrary("data.TagType");
class TagMasterTable extends TableObjectBase{
	var $tagId;
	var $name;
	var $active;
	var $tagTypeId;

	function TagMasterTable(
		$tagId=null
	){
		$this->tagId = 0;
		$this->name = null;
		$this->active = true;
		$this->tagTypeId = 1;
		$this->setTagId($tagId);
	}

	function setTagId($value){
		$this->tagId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getTagId(){
		return $this->tagId;
	}
	function setName($value){
		$this->name = $value;
	}
	function getName(){
		return $this->name;
	}
	function setActive($value){
		$this->active = $value;
	}
	function getActive(){
		return $this->active;
	}
	function setTagTypeId($value){
		$this->tagTypeId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getTagTypeId(){
		return $this->tagTypeId;
	}
	
	function columnTagId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TAG","TAG_MASTER"),"TAG_ID","TagId","SERIAL");
	}
	function columnName(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TAG","TAG_MASTER"),"NAME","Name","STRING");
	}
	function columnActive(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TAG","TAG_MASTER"),"ACTIVE","Active","BOOLEAN");
	}
	function columnTagTypeId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."TAG","TAG_MASTER"),"TAG_TYPE_ID","TagTypeId","INTEGER");
	}

	function __columns(){
		return array(
				$this->columnTagId()
				,$this->columnName()
				,$this->columnActive()
				,$this->columnTagTypeId()
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnTagId()
				);
	}

	function criteriaTagTypeId($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			TagType::columnTagTypeId(),
			$this->getTagTypeId()
		);
		return $criteria;
	}


	function related($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			TagType::columnTagTypeId(),
			TagMaster::columnTagTypeId()
		);
		
		return $criteria;
	}
	function __verify(){
		$verify = new TagMasterVerify();
		return $verify->verify($this);
	}
}
?>