<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class FileInfoTableVerify{
	var $errorList = array();

	function FileInfoTableVerify(){
	}
	function verify($tableObject){
		$this->verifyFileId($tableObject->getFileId());
		$this->verifyName($tableObject->getName());
		$this->verifyPath($tableObject->getPath());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				ExceptionTrigger::raise($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyFileId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException(array($this->namedFileId()));
		}
		unset($value);
	}
	function verifyName($value){
		if(!Validate::isString($value,0,255)){
			$this->errorList[] = new MaxLengthException(array($this->namedName(),255));
		}
		unset($value);
	}
	function verifyPath($value){
		if(!Validate::isString($value,0,255)){
			$this->errorList[] = new MaxLengthException(array($this->namedPath(),255));
		}
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException(array($this->namedPath()));
		}
		unset($value);
	}

	function namedFileId(){
		return Message::_("FILE_ID");
	}
	function namedName(){
		return Message::_("NAME");
	}
	function namedPath(){
		return Message::_("PATH");
	}
}

?>