<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.verify.FileInfoVerify");
Rhaco::importLibrary("data.TaskFileRelation");
class FileInfoTable extends TableObjectBase{
	var $fileId;
	var $name;
	var $path;

	function FileInfoTable(
		$fileId=null
	){
		$this->fileId = 0;
		$this->name = null;
		$this->path = null;
		$this->setFileId($fileId);
	}

	function setFileId($value){
		$this->fileId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getFileId(){
		return $this->fileId;
	}
	function setName($value){
		$this->name = $value;
	}
	function getName(){
		return $this->name;
	}
	function setPath($value){
		$this->path = $value;
	}
	function getPath(){
		return $this->path;
	}
	
	function columnFileId(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."FILE_INFO","FILE_INFO"),"FILE_ID","FileId","SERIAL");
	}
	function columnName(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."FILE_INFO","FILE_INFO"),"NAME","Name","STRING");
	}
	function columnPath(){
		return new Column(new Table(Rhaco::define("DATABASE_workstyle_PREFIX")."FILE_INFO","FILE_INFO"),"PATH","Path","STRING");
	}

	function __columns(){
		return array(
				$this->columnFileId()
				,$this->columnName()
				,$this->columnPath()
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnFileId()
				);
	}


	function dependColumnFileId(){
		$list	= array();
	
		$criteria = new Criteria();
		$criteria->add(TaskFileRelation::columnFileId(),$this->getFileId());
		$list[] = array(new TaskFileRelation(),$criteria);
		
		return $list;
	}

	function related($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		
		return $criteria;
	}
	function __verify(){
		$verify = new FileInfoVerify();
		return $verify->verify($this);
	}
}
?>