<?php
Rhaco::import("lang.Variable");
Rhaco::import("util.Pager");
Rhaco::importLibrary("WorkStyle");

class TaskQuery{
	var $limit;
	var $offset;
	var $sortOrder;
	var $sortType;
	var $keyword;
	var $onStatusList = array();
	var $onTagIdList = array();
	var $onTagList = array();	
	var $notOnTagIdList = array();

	function TaskQuery(){
		$this->limit	= WorkStyle::getListCount();
		$this->sortType	= true;
	}
	
	function setOffset($value){
		$this->offset = intval($value);
	}
	function setLimit($value){
		if(empty($value)){
			$value = WorkStyle::getListCount();
		}
		$this->limit = intval($value);
	}
	function getPager(){
		$pager = new Pager();
		$pager->setLimit($this->limit);
		$pager->setOffset($this->offset);
		
		return $pager;
	}
	
	function setSortType($value){
		if(!empty($value)){
			$this->sortType = Variable::getBoolean($value);
		}
	}
	function setSortOrder($value){
		if($value >= 1 && $value <= 4){
			$this->sortOrder = $value;
		}else{
			$this->sortOrder = $this->orderStatus();
		}
	}
	function setOnStatus($value){
		$this->onStatusList = preg_split("/,/",$value,-1,PREG_SPLIT_NO_EMPTY);
	}
	function hasOnStatus(){
		return (sizeof($this->onStatusList) > 0);
	}
	function setOnTag($value){
		$this->onTagIdList = preg_split("/,/",$value,-1,PREG_SPLIT_NO_EMPTY);
	}
	function setNotOnTag($value){
		$this->notOnTagIdList = preg_split("/,/",$value,-1,PREG_SPLIT_NO_EMPTY);
	}
	function getOnTagList($tagList){
		$list = array();
		
		foreach($this->onTagIdList as $tagId){
			foreach($tagList as $tag){
				if($tagId == $tag->tagId){
					array_push($list,$tag);
				}
			}
		}
		return $list;
	}
	function getNotOnTagList($tagList){
		$list = array();
		
		foreach($this->notOnTagIdList as $tagId){
			foreach($tagList as $tag){
				if($tagId == $tag->tagId){
					array_push($list,$tag);
				}
			}
		}
		return $list;
	}		
	function hasOnTag(){
		return (sizeof($this->onTagIdList) > 0);
	}
	function setKeyword($value){
		$this->keyword = $value;
	}
	function hasKeyword(){
		return !empty($this->keyword);
	}
		
	function orderStatus(){
		return 1;
	}
	function orderTaskId(){
		return 2;
	}
	function orderEstimate(){
		return 3;
	}
	function orderUpdateDate(){
		return 4;
	}
}
?>