<?php
require_once("./define.php");
Rhaco::import("network.http.BasicLoginRequestValidate");
Rhaco::import("network.http.Header");
Rhaco::importLibrary("WorkStyle");
Rhaco::importLibrary("data.TaskQuery");

$requestValidate 	= new BasicLoginRequestValidate();
$workStyle			= new WorkStyle($requestValidate);

if($requestValidate->isPost()){
	$task = $workStyle->getTask($requestValidate->getElement("taskId"));	
	$submit = false;

	if($task){
		switch($requestValidate->getElement("actionType")){
			case 1:
				$task->setStatusId($requestValidate->getElement("statusId"));
				$submit = $workStyle->updateTask($task);
				break;
			case 2:
				$submit = $workStyle->dropTask($requestValidate->getElement("taskId"));
				break;
			case 3:
				$submit = $workStyle->linkTask($requestValidate->getElement("taskId"),$requestValidate->getElement("relationTaskId"));
				break;
		}
	}
	if($submit){
		Header::redirect(Rhaco::url("taskList.php"),$workStyle->query($requestValidate->getElements()));
	}
}
$taskResult = $workStyle->listTask($requestValidate->toObject(new TaskQuery()));
$requestValidate->setElement("pager",$taskResult->getPager());
$requestValidate->setElement("taskList",$taskResult->getList());

$requestValidate->setElement("tagMasterList",$workStyle->listTag());
$requestValidate->setElement("tagTypeList",$workStyle->listTagType());

$workStyle->template($requestValidate->getElements(),"TaskList.html");
?>