<?php
require_once("./define.php");
Rhaco::import("network.http.Header");
Rhaco::import("network.http.BasicLoginRequestValidate");
Rhaco::importLibrary("WorkStyle");

$requestValidate 	= new BasicLoginRequestValidate();
$workStyle			= new WorkStyle($requestValidate);

if($requestValidate->isPost()){
	$task = $workStyle->getTask($requestValidate->getElement("taskId"));	
	$submit = false;
	
	if($task){
		switch($requestValidate->getElement("actionType")){
			case 1:
				$task->setStatusId($requestValidate->getElement("statusId"));
				$submit = $workStyle->updateTask($task);
				break;
			case 2:
				$task->setTagList($requestValidate->getElement("tagList"));
				$submit = $workStyle->updateTask($task);
				break;
			case 3:
				$submit = $workStyle->insertFile(
							$requestValidate->getElement("taskId"),
							$requestValidate->getFile("attachFile")
							);
				break;
			case 4:
				$submit = $workStyle->dropFile(
							$requestValidate->getElement("taskId"),
							$requestValidate->getElement("fileId")
							);
				break;
			case 5:
				$taskCommnet = new TaskComment();
				$taskCommnet->setTaskId($requestValidate->getElement("taskId"));
				$taskCommnet->setContents($requestValidate->getElement("contents"));
				$taskCommnet->setCommentator($requestValidate->getElement("commentator"));
				if($workStyle->insertComment($taskCommnet)){
					$requestValidate->clearElement("commentator");
					$requestValidate->clearElement("contents");
					$submit = true;
				}
				break;
			case 6:
				$submit = $workStyle->dropLinkTask($requestValidate->getElement("taskId"),$requestValidate->getElement("relationTaskId"));
				break;
		}
	}
	if($submit){
		$query = $workStyle->query($requestValidate->getElements());
		$query["taskId"] = $requestValidate->getElement("taskId");
		Header::redirect(Rhaco::url("taskDetail.php"),$query);
	}
}
$task = $workStyle->getTask($requestValidate->getElement("taskId"));

if(empty($task)){
	Header::redirect(Rhaco::url("TaskList.php"),$requestValidate->getElements());
}
$requestValidate->setElement("task",$task);
$requestValidate->setElement("tagMasterList",$workStyle->listTag());
$requestValidate->setElement("tagTypeList",$workStyle->listTagType());

$workStyle->template($requestValidate->getElements(),"TaskDetail.html");
?>