CREATE TABLE WS_TAG_TYPE (
	 TAG_TYPE_ID SERIAL
	,NAME VARCHAR(20)
	,SORT_ORDER INTEGER DEFAULT 0
	,PRIMARY KEY(TAG_TYPE_ID)
);

CREATE TABLE WS_TAG (
	 TAG_ID SERIAL
	,NAME VARCHAR(20) NOT NULL
	,ACTIVE BIT NOT NULL DEFAULT 'B1'
	,TAG_TYPE_ID INTEGER NOT NULL DEFAULT 1
	,PRIMARY KEY(TAG_ID)
);

CREATE TABLE WS_TASK (
	 TASK_ID SERIAL
	,CONTENTS TEXT NOT NULL
	,ESTIMATED_MAN_HOUR INTEGER DEFAULT 0
	,TAG_LIST VARCHAR(200)
	,UPDATE_DATE TIMESTAMP DEFAULT 'now'
	,REGIST_DATE TIMESTAMP DEFAULT 'now'
	,CREATOR VARCHAR(50)
	,STATUS_ID INTEGER NOT NULL DEFAULT 3
	,PRIMARY KEY(TASK_ID)
);

CREATE TABLE WS_TASK_COMMENT (
	 COMMENT_ID SERIAL
	,CONTENTS VARCHAR(1000) NOT NULL
	,COMMENTATOR VARCHAR(50)
	,UPDATE_DATE TIMESTAMP DEFAULT 'now'
	,TASK_ID INTEGER
	,PRIMARY KEY(COMMENT_ID)
);

CREATE TABLE WS_TASK_RELATION (
	 SRC_TASK_ID INTEGER
	,DEST_TASK_ID INTEGER
	,PRIMARY KEY(SRC_TASK_ID,DEST_TASK_ID)
);

CREATE TABLE WS_TASK_FILE_RELATION (
	 TASK_ID INTEGER NOT NULL
	,FILE_ID INTEGER NOT NULL
);

CREATE TABLE WS_FILE_INFO (
	 FILE_ID SERIAL
	,NAME VARCHAR(255)
	,PATH VARCHAR(255) NOT NULL
	,PRIMARY KEY(FILE_ID)
);

ALTER TABLE WS_TAG ADD CONSTRAINT FK_WS_TAG_TAG_TYPE_ID FOREIGN KEY (TAG_TYPE_ID) REFERENCES WS_TAG_TYPE(TAG_TYPE_ID);
ALTER TABLE WS_TASK_COMMENT ADD CONSTRAINT FK_WS_TASK_COMMENT_TASK_ID FOREIGN KEY (TASK_ID) REFERENCES WS_TASK(TASK_ID);
ALTER TABLE WS_TASK_RELATION ADD CONSTRAINT FK_WS_TASK_RELATION_SRC_TASK_ID FOREIGN KEY (SRC_TASK_ID) REFERENCES WS_TASK(TASK_ID);
ALTER TABLE WS_TASK_RELATION ADD CONSTRAINT FK_WS_TASK_RELATION_DEST_TASK_ID FOREIGN KEY (DEST_TASK_ID) REFERENCES WS_TASK(TASK_ID);
ALTER TABLE WS_TASK_FILE_RELATION ADD CONSTRAINT FK_WS_TASK_FILE_RELATION_TASK_ID FOREIGN KEY (TASK_ID) REFERENCES WS_TASK(TASK_ID);
ALTER TABLE WS_TASK_FILE_RELATION ADD CONSTRAINT FK_WS_TASK_FILE_RELATION_FILE_ID FOREIGN KEY (FILE_ID) REFERENCES WS_FILE_INFO(FILE_ID);


insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type1',1);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type2',2);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type4',3);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type4',4);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type5',5);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type6',6);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type7',7);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type8',8);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type9',9);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type10',10);
