CREATE TABLE IF NOT EXISTS WS_TAG_TYPE (
	 `TAG_TYPE_ID` INTEGER AUTO_INCREMENT 
	,`NAME` VARCHAR(20)
	,`SORT_ORDER` INTEGER DEFAULT 0
	,PRIMARY KEY(`TAG_TYPE_ID`)
) TYPE = innodb;

CREATE TABLE IF NOT EXISTS WS_TAG (
	 `TAG_ID` INTEGER AUTO_INCREMENT 
	,`NAME` VARCHAR(20) NOT NULL
	,`ACTIVE` TINYINT(1) NOT NULL DEFAULT 1
	,`TAG_TYPE_ID` INTEGER NOT NULL DEFAULT 1
	,PRIMARY KEY(`TAG_ID`)
) TYPE = innodb;

CREATE TABLE IF NOT EXISTS WS_TASK (
	 `TASK_ID` INTEGER AUTO_INCREMENT 
	,`CONTENTS` LONGBLOB NOT NULL
	,`ESTIMATED_MAN_HOUR` INTEGER DEFAULT 0
	,`TAG_LIST` VARCHAR(200)
	,`UPDATE_DATE` TIMESTAMP(14)
	,`REGIST_DATE` TIMESTAMP(14)
	,`CREATOR` VARCHAR(50)
	,`STATUS_ID` INTEGER NOT NULL DEFAULT 3
	,PRIMARY KEY(`TASK_ID`)
) TYPE = innodb;

CREATE TABLE IF NOT EXISTS WS_TASK_COMMENT (
	 `COMMENT_ID` INTEGER AUTO_INCREMENT 
	,`CONTENTS` LONGBLOB NOT NULL
	,`COMMENTATOR` VARCHAR(50)
	,`UPDATE_DATE` TIMESTAMP(14)
	,`TASK_ID` INTEGER
	,PRIMARY KEY(`COMMENT_ID`)
) TYPE = innodb;

CREATE TABLE IF NOT EXISTS WS_TASK_RELATION (
	 `SRC_TASK_ID` INTEGER
	,`DEST_TASK_ID` INTEGER
	,PRIMARY KEY(`SRC_TASK_ID`,`DEST_TASK_ID`)
) TYPE = innodb;

CREATE TABLE IF NOT EXISTS WS_TASK_FILE_RELATION (
	 `TASK_ID` INTEGER NOT NULL
	,`FILE_ID` INTEGER NOT NULL
) TYPE = innodb;

CREATE TABLE IF NOT EXISTS WS_FILE_INFO (
	 `FILE_ID` INTEGER AUTO_INCREMENT 
	,`NAME` LONGBLOB
	,`PATH` LONGBLOB NOT NULL
	,PRIMARY KEY(`FILE_ID`)
) TYPE = innodb;



insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type1',1);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type2',2);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type4',3);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type4',4);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type5',5);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type6',6);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type7',7);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type8',8);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type9',9);
insert into WS_TAG_TYPE(NAME,SORT_ORDER) values('type10',10);
