<?php
Rhaco::import("test.Validate");
Rhaco::import("exception.VariableExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");

class TaskRelationTableVerify{
	var $errorList = array();

	function TaskRelationTableVerify(){
	}
	function verify($tableObject){
		$this->verifySrcTaskId($tableObject->getSrcTaskId());
		$this->verifyDestTaskId($tableObject->getDestTaskId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				VariableExceptionTrigger::error($exception);
			}
			return false;
		}
		return true;	
	}

	function verifySrcTaskId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedSrcTaskId()));
		}
	}
	function verifyDestTaskId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedDestTaskId()));
		}
	}

	function namedSrcTaskId(){
		return "SRC_TASK_ID";
	}
	function namedDestTaskId(){
		return "DEST_TASK_ID";
	}
}

?>