<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.verify.TaskRelationVerify");
Rhaco::importLibrary("data.TaskMaster");
Rhaco::importLibrary("data.TaskMaster");
class TaskRelationTable extends TableObjectBase{
	var $srcTaskId;
	var $destTaskId;

	function TaskRelationTable(
		$srcTaskId=null
		,$destTaskId=null
	){
		$this->srcTaskId = 0;
		$this->destTaskId = 0;
		$this->setSrcTaskId($srcTaskId);
		$this->setDestTaskId($destTaskId);
	}

	function setSrcTaskId($value){
		$this->srcTaskId = sprintf("%d",$value);
	}
	function getSrcTaskId(){
		return $this->srcTaskId;
	}
	function setDestTaskId($value){
		$this->destTaskId = sprintf("%d",$value);
	}
	function getDestTaskId(){
		return $this->destTaskId;
	}
	
	function columnSrcTaskId(){
		return new Column(new Table("WS_TASK_RELATION","TASK_RELATION"),"SRC_TASK_ID","SrcTaskId","INTEGER");
	}
	function columnDestTaskId(){
		return new Column(new Table("WS_TASK_RELATION","TASK_RELATION"),"DEST_TASK_ID","DestTaskId","INTEGER");
	}

	function __columns(){
		return array(
				$this->columnSrcTaskId()
				,$this->columnDestTaskId()
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnSrcTaskId()
				,$this->columnDestTaskId()
				);
	}

	function criteriaSrcTaskId($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			TaskMaster::columnTaskId(),
			$this->getSrcTaskId()
		);
		return $criteria;
	}
	function criteriaDestTaskId($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		$criteria->add(
			TaskMaster::columnTaskId(),
			$this->getDestTaskId()
		);
		return $criteria;
	}
	function __verify(){
		$verify = new TaskRelationVerify();
		return $verify->verify($this);
	}

	function __isTable(){
		return true;
	}
}
?>