<?php
Rhaco::import("test.Validate");
Rhaco::import("exception.VariableExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");

class TaskMasterTableVerify{
	var $errorList = array();

	function TaskMasterTableVerify(){
	}
	function verify($tableObject){
		$this->verifyTaskId($tableObject->getTaskId());
		$this->verifyContents($tableObject->getContents());
		$this->verifyEstimatedManHour($tableObject->getEstimatedManHour());
		$this->verifyTagList($tableObject->getTagList());
		$this->verifyUpdateDate($tableObject->getUpdateDate());
		$this->verifyRegistDate($tableObject->getRegistDate());
		$this->verifyCreator($tableObject->getCreator());
		$this->verifyStatusId($tableObject->getStatusId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				VariableExceptionTrigger::error($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyTaskId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedTaskId()));
		}
	}
	function verifyContents($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedContents()));
		}
	}
	function verifyEstimatedManHour($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedEstimatedManHour()));
		}
	}
	function verifyTagList($value){
		if(!Validate::isString($value,0,200)){
			$this->errorList[] = new MaxLengthException($this,"",array($this->namedTagList(),200));
		}
	}
	function verifyUpdateDate($value){
		if(!Validate::isTimestamp($value)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedUpdateDate()));
		}
	}
	function verifyRegistDate($value){
		if(!Validate::isTimestamp($value)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedRegistDate()));
		}
	}
	function verifyCreator($value){
		if(!Validate::isString($value,0,50)){
			$this->errorList[] = new MaxLengthException($this,"",array($this->namedCreator(),50));
		}
	}
	function verifyStatusId($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedStatusId()));
		}
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedStatusId()));
		}
	}

	function namedTaskId(){
		return "TASK_ID";
	}
	function namedContents(){
		return "CONTENTS";
	}
	function namedEstimatedManHour(){
		return "ESTIMATED_MAN_HOUR";
	}
	function namedTagList(){
		return "TAG_LIST";
	}
	function namedUpdateDate(){
		return "UPDATE_DATE";
	}
	function namedRegistDate(){
		return "REGIST_DATE";
	}
	function namedCreator(){
		return "CREATOR";
	}
	function namedStatusId(){
		return "STATUS_ID";
	}
}

?>