<?php
Rhaco::import("test.Validate");
Rhaco::import("exception.VariableExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");

class TaskFileRelationTableVerify{
	var $errorList = array();

	function TaskFileRelationTableVerify(){
	}
	function verify($tableObject){
		$this->verifyTaskId($tableObject->getTaskId());
		$this->verifyFileId($tableObject->getFileId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				VariableExceptionTrigger::error($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyTaskId($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedTaskId()));
		}
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedTaskId()));
		}
	}
	function verifyFileId($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedFileId()));
		}
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedFileId()));
		}
	}

	function namedTaskId(){
		return "TASK_ID";
	}
	function namedFileId(){
		return "FILE_ID";
	}
}

?>