<?php
Rhaco::import("test.Validate");
Rhaco::import("exception.VariableExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");

class TaskCommentTableVerify{
	var $errorList = array();

	function TaskCommentTableVerify(){
	}
	function verify($tableObject){
		$this->verifyCommentId($tableObject->getCommentId());
		$this->verifyContents($tableObject->getContents());
		$this->verifyCommentator($tableObject->getCommentator());
		$this->verifyUpdateDate($tableObject->getUpdateDate());
		$this->verifyTaskId($tableObject->getTaskId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				VariableExceptionTrigger::error($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyCommentId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedCommentId()));
		}
	}
	function verifyContents($value){
		if(!Validate::isString($value,0,1000)){
			$this->errorList[] = new MaxLengthException($this,"",array($this->namedContents(),1000));
		}
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedContents()));
		}
	}
	function verifyCommentator($value){
		if(!Validate::isString($value,0,50)){
			$this->errorList[] = new MaxLengthException($this,"",array($this->namedCommentator(),50));
		}
	}
	function verifyUpdateDate($value){
		if(!Validate::isTimestamp($value)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedUpdateDate()));
		}
	}
	function verifyTaskId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedTaskId()));
		}
	}

	function namedCommentId(){
		return "COMMENT_ID";
	}
	function namedContents(){
		return "CONTENTS";
	}
	function namedCommentator(){
		return "COMMENTATOR";
	}
	function namedUpdateDate(){
		return "UPDATE_DATE";
	}
	function namedTaskId(){
		return "TASK_ID";
	}
}

?>