<?php
Rhaco::import("test.Validate");
Rhaco::import("exception.VariableExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");

class TagTypeTableVerify{
	var $errorList = array();

	function TagTypeTableVerify(){
	}
	function verify($tableObject){
		$this->verifyTagTypeId($tableObject->getTagTypeId());
		$this->verifyName($tableObject->getName());
		$this->verifySortOrder($tableObject->getSortOrder());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				VariableExceptionTrigger::error($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyTagTypeId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedTagTypeId()));
		}
	}
	function verifyName($value){
		if(!Validate::isString($value,0,20)){
			$this->errorList[] = new MaxLengthException($this,"",array($this->namedName(),20));
		}
	}
	function verifySortOrder($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedSortOrder()));
		}
	}

	function namedTagTypeId(){
		return "TAG_TYPE_ID";
	}
	function namedName(){
		return "NAME";
	}
	function namedSortOrder(){
		return "SORT_ORDER";
	}
}

?>