<?php
Rhaco::import("test.Validate");
Rhaco::import("exception.VariableExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");

class TagMasterTableVerify{
	var $errorList = array();

	function TagMasterTableVerify(){
	}
	function verify($tableObject){
		$this->verifyTagId($tableObject->getTagId());
		$this->verifyName($tableObject->getName());
		$this->verifyActive($tableObject->getActive());
		$this->verifyTagTypeId($tableObject->getTagTypeId());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				VariableExceptionTrigger::error($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyTagId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedTagId()));
		}
	}
	function verifyName($value){
		if(!Validate::isString($value,0,20)){
			$this->errorList[] = new MaxLengthException($this,"",array($this->namedName(),20));
		}
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedName()));
		}
	}
	function verifyActive($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedActive()));
		}
	}
	function verifyTagTypeId($value){
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedTagTypeId()));
		}
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedTagTypeId()));
		}
	}

	function namedTagId(){
		return "TAG_ID";
	}
	function namedName(){
		return "NAME";
	}
	function namedActive(){
		return "ACTIVE";
	}
	function namedTagTypeId(){
		return "TAG_TYPE_ID";
	}
}

?>