<?php
Rhaco::import("test.Validate");
Rhaco::import("exception.VariableExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");

class FileInfoTableVerify{
	var $errorList = array();

	function FileInfoTableVerify(){
	}
	function verify($tableObject){
		$this->verifyFileId($tableObject->getFileId());
		$this->verifyName($tableObject->getName());
		$this->verifyPath($tableObject->getPath());
		if(!empty($this->errorList)){
			foreach($this->errorList as $exception){
				VariableExceptionTrigger::error($exception);
			}
			return false;
		}
		return true;	
	}

	function verifyFileId($value){
		if(!Validate::isIntegerLength($value,22)){
			$this->errorList[] = new DataTypeException($this,"",array($this->namedFileId()));
		}
	}
	function verifyName($value){
		if(!Validate::isString($value,0,255)){
			$this->errorList[] = new MaxLengthException($this,"",array($this->namedName(),255));
		}
	}
	function verifyPath($value){
		if(!Validate::isString($value,0,255)){
			$this->errorList[] = new MaxLengthException($this,"",array($this->namedPath(),255));
		}
		if($value == "" || $value == null){
			$this->errorList[] = new RequireException($this,"",array($this->namedPath()));
		}
	}

	function namedFileId(){
		return "FILE_ID";
	}
	function namedName(){
		return "NAME";
	}
	function namedPath(){
		return "PATH";
	}
}

?>