<?php
Rhaco::import("Rhaco");
Rhaco::import("database.DbUtil");
Rhaco::import("database.data.Criteria");
Rhaco::import("tag.HtmlParser");
Rhaco::import("io.FileUtil");
Rhaco::import("lang.DateUtil");

Rhaco::importLibrary("data.DbConnectionWorkstyle");
Rhaco::importLibrary("data.TaskMaster");
Rhaco::importLibrary("data.TagMaster");
Rhaco::importLibrary("data.TaskComment");
Rhaco::importLibrary("data.TaskResult");
Rhaco::importLibrary("data.TagType");
Rhaco::importLibrary("data.FileInfo");
Rhaco::importLibrary("data.TaskFileRelation");
Rhaco::importLibrary("data.TaskComment");
Rhaco::importLibrary("data.TaskRelation");

Rhaco::importLibrary("data.TaskQuery");

class WorkStyle{
	var $dbUtil;
	var $htmlParser;
	var $requestValidate;
	var $tagList		= array();
	var $tagTypeList = array();
	
	function getListCount(){
		return Rhaco::getDefinePath("LIST_LIMIT",10);
	}

	function WorkStyle(&$requestValidate){
		$this->dbUtil			= new DbUtil(new DbConnectionWorkstyle());
		$this->htmlParser		= new HtmlParser();
		$this->requestValidate	= $requestValidate;

		$this->_setTagTypeList();
		$this->_setTagList();
	}

	function template($request,$templateFileName){
		$templateFilePath = Rhaco::define("TEMPLATE","default");

		$this->htmlParser->addReplace("./Download.html",Rhaco::url("util/download.php"));
		$this->htmlParser->addReplace("./atom.xml",Rhaco::url("util/atom.php"));
		$this->htmlParser->addReplace("./rdf.xml",Rhaco::url("util/rdf.php"));
						
		$this->htmlParser->addReplace("./TaskDetail.html",Rhaco::url("taskDetail.php"));
		$this->htmlParser->addReplace("./TaskList.html",Rhaco::url("taskList.php"));
		$this->htmlParser->addReplace("./TagList.html",Rhaco::url("tagList.php"));
		$this->htmlParser->addReplace("./TagTypeList.html",Rhaco::url("tagTypeList.php"));
		$this->htmlParser->addReplace("./TaskForm.html",Rhaco::url("taskForm.php"));

		$request["skin"]		= $templateFilePath;
		$request["query"]	= $this->query($request);

		$this->htmlParser->setRequest($request);
		$this->htmlParser->clearCash(sprintf("%s/%s",$templateFilePath,$templateFileName));
		$this->htmlParser->write(sprintf("%s/%s",$templateFilePath,$templateFileName),Rhaco::templateurl($templateFilePath));
	}
	function query($request){
		$query					= array();
		$query["offset"]			= $request["offset"];
		$query["limit"]			= $request["limit"];
		$query["sortType"]		= $request["sortType"];
		$query["sortOrder"]		= $request["sortOrder"];
		$query["keyword"]		= $request["keyword"];
		$query["onStatus"]		= $request["onStatus"];
		$query["onTag"]			= $request["onTag"];
		$query["relationTaskId"]	= $request["relationTaskId"];

		return $query;
	}
	
	function getTask($taskId){
		$task = $this->dbUtil->get(new TaskMaster($taskId));
		if($task){
			$criteria = new Criteria();
			$criteria->add(FileInfo::columnFileId(),TaskFileRelation::columnFileId());
			$criteria->add(TaskFileRelation::columnTaskId(),$taskId);
			
			$task->setFileList($this->dbUtil->select(new FileInfo(),$criteria));
			
			$criteria = new Criteria();
			$criteria->add(TaskComment::columnTaskId(),$taskId);
			$task->setCommentList($this->dbUtil->select(new TaskComment(),$criteria));

			$criteria = new Criteria();
			$criteria->addDistinct(TaskMaster::columnTaskId());			

			$criteriaSrc = new Criteria();
			$criteriaSrc->add(TaskRelation::columnDestTaskId(),$taskId);	
			$criteriaSrc->add(TaskRelation::columnSrcTaskId(),TaskMaster::columnTaskId());
			$criteriaDesc = new Criteria();
			$criteriaDesc->add(TaskRelation::columnSrcTaskId(),$taskId);			
			$criteriaDesc->add(TaskRelation::columnDestTaskId(),TaskMaster::columnTaskId());

			$criteriaRelation = new Criteria();
			$criteriaRelation->addCriteriaOr($criteriaSrc);
			$criteriaRelation->addCriteriaOr($criteriaDesc);			
			$criteria->addCriteria($criteriaRelation);
			
			$task->setRelationTask($this->dbUtil->select(new TaskMaster(),$criteria));
			$task->setTagTypeId($this->listTag());			
			return $task;
		}
		return false;
	}
	function insertTask($task,$relationTaskId=0){
		if($this->_invalidLoginForward("TASK_INSERT")){
			$task->setUpdateDate(time());
			$task->setRegistDate(time());			
			$task = $this->dbUtil->insert($task);
			
			if($task){
				$this->_updateTag($task);
				$this->linkTask($task->getTaskId(),$relationTaskId);
	
				return true;
			}
		}
		return false;
	}
	function linkTask($taskId,$relationTaskId){
		if($relationTaskId > 0 && $taskId > 0){
			if($this->_invalidLoginForward("TASK_LINK")){						
				$relationTask = new TaskRelation();
				$relationTask->setSrcTaskId($taskId);
				$relationTask->setDestTaskId(intval($relationTaskId));
				
				return $this->dbUtil->insert($relationTask);
			}
		}
		return false;
	}
	function dropLinkTask($taskId,$relationTaskId){
		if($relationTaskId > 0 && $taskId > 0){
			if($this->_invalidLoginForward("TASK_LINK_DELETE")){

				$relationTask = new TaskRelation();
				$relationTask->setSrcTaskId($taskId);
				$relationTask->setDestTaskId(intval($relationTaskId));				
				$this->dbUtil->delete($relationTask);
				
				$relationTask = new TaskRelation();
				$relationTask->setSrcTaskId($relationTaskId);
				$relationTask->setDestTaskId(intval($taskId));
				$this->dbUtil->delete($relationTask);
				
				return true;
			}
		}
		return false;
	}
	function updateTask($task){
		if($this->_invalidLoginForward("TASK_UPDATE")){	
			$task->setUpdateDate(time());
			if($this->dbUtil->update($task)){
				$this->_updateTag($task);
				return true;
			}
		}
		return false;
	}
	function updateListTask($query){
		$criteria	= new Criteria();
		$criteria	= $this->_listCriteria($criteria,$query);
		$criteria->addGreater(TaskMaster::columnUpdateDate(),DateUtil::addDay(time(),-1));
		return $this->dbUtil->select(new TaskMaster(),$criteria);
	}
	function listTask($query){
		$taskResult	= new TaskResult($query);
		$criteria	= new Criteria();
		$criteria	= $this->_listCriteria($criteria,$query);
		$taskResult->setTotal($this->dbUtil->count(new TaskMaster(),$criteria));

		$criteria->setPager($query->getPager());
		$taskResult->setList($this->dbUtil->select(new TaskMaster(),$criteria),$this->tagList);

		return $taskResult;
	}

	function dropTask($taskId){
		if($this->_invalidLoginForward("TASK_DELETE")){
			$task = $this->getTask($taskId);
	
			if($task){			
				foreach($task->fileList as $value){
					$this->_dropFile($task->getTaskId(),$value->getFileId());
				}
				foreach($task->commentList as $value){
					$this->dbUtil->delete($value);
				}
				foreach($task->relationTask as $value){
					$this->dbUtil->delete($value);
				}
				return $this->dbUtil->delete($task);
			}
		}
		return false;
	}

	function dropTag($tag){
		if($this->_invalidLoginForward("TAG_DELETE")){
			$criteria = new Criteria();
			$criteria->addLike(TaskMaster::columnTagList(),sprintf(".*[%s].*",$tag->name));
			$taskList = $this->dbUtil->select(new TaskMaster(),$criteria);
	
			foreach($taskList as $task){
				$task->setTagList(str_replace(sprintf("[%s]",$tag->name)),"",$task->getTagList());
				$this->dbUtil->update($task);
			}
			if($this->dbUtil->delete($tag)){
				$this->_setTagList();	
				return true;
			}
		}
		return false;
	}
	function updateTag($tag){
		if($this->_invalidLoginForward("TAG_UPDATE")){
			if($this->dbUtil->update($tag)){
				$this->_setTagList();
				return true;
			}
		}
		return false;
	}

	function changeTagType($tagTypeNameList,$tagTypeSortOrderList){
		if($this->_invalidLoginForward("TAG_TYPE_UPDATE")){
			$bool = false;
			
			if(is_array($tagTypeNameList)){
				foreach($this->tagTypeList as $tagType){
					foreach($tagTypeNameList as $tagTypeId => $tagTypeName){
						if($tagTypeId == $tagType->getTagTypeId()){
							$tagType->setName($tagTypeName);
							$tagType->setSortOrder($tagTypeSortOrderList[$tagTypeId]);					
							$bool = $this->dbUtil->update($tagType);
							break;
						}
					}
				}
			}
			if($bool){
				$this->_setTagTypeList();
				return true;
			}
		}
		return false;
	}
	
	function getTag($tagId){
		return $this->dbUtil->get(new TagMaster($tagId));
	}
	function listTag(){
		return $this->tagList;
	}
	function listTagType(){
		return $this->tagTypeList;
	}

	function insertFile($taskId,$file){
		if($this->_invalidLoginForward("TASK_FILE_INSERT")){
			if($file){
				$oldFileName	= $file->getName();
				$filename	= sprintf("%s_%s%s",$taskId,uniqid(""),$file->getExtension());

				if($file->generate($this->_filepath($filename))){
					$fileInfo = new FileInfo();
					$fileInfo->setPath($filename);
					$fileInfo->setName($oldFileName);
					$fileInfo = $this->dbUtil->insert($fileInfo);
	
					if($fileInfo){
						$fileRelation = new TaskFileRelation();
						$fileRelation->setTaskId($taskId);
						$fileRelation->setFileId($fileInfo->getFileId());
						$this->dbUtil->insert($fileRelation);
	
						return true;					
					}
				}
			}
		}
		return false;
	}
	function _filepath($filename){
		return Rhaco::webapp(sprintf("/resources/files/%s",$filename));
	}
	function dropFile($taskId,$fileId){
		if($this->_invalidLoginForward("TASK_FILE_DELETE")){
			return $this->_dropFile($taskId,$fileId);
		}
		return false;
	}
	function _dropFile($taskId,$fileId){
		$criteria = new Criteria();
		$criteria->add(TaskFileRelation::columnTaskId(),$taskId);
		$criteria->add(TaskFileRelation::columnFileId(),$fileId);

		$this->dbUtil->delete(new TaskFileRelation(),$criteria);

		$fileInfo = $this->dbUtil->get(new FileInfo($fileId));
				
		$fileUtil = new FileUtil();
		$fileUtil->rm($this->_filepath($fileInfo->getPath()));
		
		return $this->dbUtil->delete($fileInfo);		
	}
	function getFile($fileId){
		$file = $this->dbUtil->get(new FileInfo($fileId));
		
		if($file){
			$file->setPath($this->_filepath($file->getPath()));
			return $file;
		}
		return false;
	}
	
	function insertComment($taskCooment){
		if($this->_invalidLoginForward("TASK_COMMENT_INSERT")){
			if($this->dbUtil->insert($taskCooment)){
				$task = $this->dbUtil->get(new TaskMaster($taskCooment->gettaskId()));
				$task->setUpdateDate(time());
				return $this->dbUtil->update($task);
			}
		}
		return false;
	}
	
	function _updateTag($task){
		foreach($task->tagNameList as $name => $value){
			$bool = false;
			
			foreach($this->tagList as $tag){
				if($tag->name == $name){
					$bool = true;
					break;
				}
			}
			if(!$bool){
				$tag = new TagMaster();
				$tag->setName($name);
				$this->dbUtil->insert($tag);
			}
		}
	}
	function _setTagTypeList(){
		$criteria = new Criteria();
		$criteria->addOrder(TagType::columnSortOrder());
		$this->tagTypeList = $this->dbUtil->select(new TagType(),$criteria);		
	}
	function _setTagList(){
		$criteria = new Criteria();
		$criteria->addOrder(TagMaster::columnTagTypeId());
		$this->tagList = $this->dbUtil->select(new TagMaster(),$criteria);		
	}
	function _invalidLoginForward($defineActionName){
		if(!Variable::getBoolean(Rhaco::define($defineActionName,false))){
			return $this->requestValidate->invalidLoginForward(Rhaco::path("resources/member.xml"));			
		}
		return true;
	}
	function _listCriteria($criteria,$query){
		if($query->sortOrder == TaskQuery::orderEstimate()){
			$orderColumn = TaskMaster::columnEstimatedManHour();
		}else if($query->sortOrder == TaskQuery::orderTaskId()){
			$orderColumn = TaskMaster::columnTaskId();
		}else if($query->sortOrder == TaskQuery::orderUpdateDate()){
			$orderColumn = TaskMaster::columnUpdateDate();
		}else{
			$orderColumn = TaskMaster::columnStatusId();
		}
		if($query->sortType){
			$criteria->addOrder($orderColumn);
		}else{
			$criteria->addOrderDesc($orderColumn);			
		}

		if($query->hasOnStatus()){
			$criteria->addIn(TaskMaster::columnStatusId(),$query->onStatusList);
		}

		foreach($query->getOnTagList($this->tagList) as $tag){
			$criteria->addLike(TaskMaster::columnTagList(),sprintf(".*[%s].*",$tag->name));
		}
		foreach($query->getNotOnTagList($this->tagList) as $tag){
			$criteria->addNotLike(TaskMaster::columnTagList(),sprintf(".*[%s].*",$tag->name));
		}
		if($query->hasKeyword()){
			if(preg_match("/^[\d]+$/",$query->keyword)){
				$criteria->add(TaskMaster::columnTaskId(),$query->keyword);
			}else{
				$keywordsCriteria	= new Criteria();
				$keywordList			= preg_split("/ /",$query->keyword,-1,PREG_SPLIT_NO_EMPTY);				
				
				foreach($keywordList as $keyword){
					$keywordCriteria = new Criteria();
					$keywordCriteria->addLike(TaskMaster::columnContents(),sprintf(".*%s.*",$keyword));
					$keywordsCriteria->addCriteriaOr($keywordCriteria);
				}
				$criteria->addCriteria($keywordsCriteria);
			}
		}
		return $criteria;
	}
}
?>