<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");

/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class Logger{
	/**	use Define
	 * LOG_SYS_LEVEL
	 * LOG_DISP_LEVEL
	 * LOG_FILE_LEVEL
	 * LOG_DISP_HTML
	 * LOG_FILE_PATH
	*/

	var $LogSysLevel		= 0;
	var $LogDispLevel	= 0;
	var $LogFileLevel	= 0;

	var $LogDispHtml		= false;	
	var $LogFilePath		= ".";

	var $LOG_DEBUG		= 4;
	var $LOG_INFO		= 3;
	var $LOG_WARNING		= 2;
	var $LOG_ERROR		= 1;
	var $LOG_NONE		= 0;

	var $hasDebug		= false;
	var $hasInfo			= false;
	var $hasWarning		= false;
	var $hasError		= false;

	var $target			= "";
	var $fileUtil		= null;

	var $messageList	= array();
		
	function Logger($target=""){
		if(is_object($target)){
			$this->target = get_class($target);
		}else{
			$this->target	= $target;
		}
		$this->fileUtil	= new FileUtil();
		$null			= null;

		if(defined("LOG_DISP_LEVEL")){
			$this->LogDispLevel	= $this->_getLevel(constant("LOG_DISP_LEVEL"));
		}
		if(defined("LOG_FILE_LEVEL")){
			$this->LogFileLevel	= $this->_getLevel(constant("LOG_FILE_LEVEL"));
		}
		if(defined("LOG_SYS_LEVEL")){
			$this->LogSysLevel	= $this->_getLevel(constant("LOG_SYS_LEVEL"));
		}

		if(defined("LOG_DISP_HTML") && Variable::getBoolean(constant("LOG_DISP_HTML"))){
			$this->LogDispHtml = true;
		}		

		if(defined("LOG_FILE_PATH")){
			$this->LogFilePath	= constant("LOG_FILE_PATH");
		}				
		if(!empty($this->LogFilePath) && preg_match("/[\/\\\\]$/",$this->LogFilePath,$null)){
			$this->LogFilePath = substr($this->LogFilePath,0,-1);
		}
	}
	
	function _getLevel($level){
		if(preg_match("/^[0-9]+$/",$level)){
			return $level;
		}else{
			if(preg_match("/debug/i",$level)){
				return $this->LOG_DEBUG;
			}else if(preg_match("/info/i",$level)){
				return $this->LOG_INFO;
			}else if(preg_match("/warn/i",$level)){
				return $this->LOG_WARNING;
			}else if(preg_match("/error/i",$level)){
				return $this->LOG_ERROR;
			}
		}
		return $this->LOG_NONE;
	}

	function _output($value,$logLevel){	
		if($this->LogFileLevel >= $logLevel){
			$logFileName = sprintf("%s/log/%s.log",$this->LogFilePath,date("Ymd"));
			$this->fileUtil->append($logFileName,$value);
		}
		if($this->LogDispLevel >= $logLevel){
			if($this->LogDispHtml){
				$value = nl2br(htmlspecialchars($value));
			}
			print($value);
		}
		if($this->LogSysLevel >= $logLevel){
			if($logLevel == $this->LOG_WARNING){
				syslog(LOG_WARNING,$value);
			}else if($logLevel == $this->LOG_ERROR){
				syslog(LOG_ERR,$value);
			}else if($logLevel == $this->LOG_INFO){
				syslog(LOG_INFO,$value);
			}else if($logLevel == $this->LOG_DEBUG){
				syslog(LOG_DEBUG,$value);
			}
		}
	}

	function _format($level,$value){
		return sprintf("[%s %s]:[%s] %s\n",$level,date("Y/m/d H:i:s"),$this->target,$value);
	}
	function warning($value){
		$this->hasWarning = true;
		$this->_output($this->_format("Warning",$value),$this->LOG_WARNING);
	}

	function error($value){
		$this->hasError = true;
		$this->_output($this->_format("Error",$value),$this->LOG_ERROR);
	}

	function info($value){
		$this->hasInfo = true;
		$this->_output($this->_format("Info",$value),$this->LOG_INFO);
	}

	function debug($value){
		$this->hasDebug = true;
		$this->_output($this->_format("Debug",$value),$this->LOG_DEBUG);
	}
	
	function isDebug(){
		return $this->hasDebug;
	}
	function isInfo(){
		return $this->hasInfo;
	}
	function isWarning(){
		return $this->hasWarning;
	}
	function isError(){
		return $this->hasError;
	}
}
?>