<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");

/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class Assert{
	var $Logger = null;
	var $method = null;
	
	function Assert(){
		$this->Logger = new Logger($this);
	}
	
	function assertEquals($arg1,$arg2){				
		if($arg1 == $arg2){
			$this->success();
		}else{
			$this->fail(sprintf("expectation [%s] : Result [%s]",$this->getString($arg1),$this->getString($arg2)));
		}
	}
	function assertNotEquals($arg1,$arg2){
		if($arg1 != $arg2){
			$this->success();
		}else{
			$this->fail(sprintf("expectation [%s] : Result [%s]",$this->getString($arg1),$this->getString($arg2)));
		}
	}	
	
	function assertTrue($arg1){
		if($arg1){
			$this->success();
		}else{
			$this->fail();
		}
	}
	function assertFalse($arg1){
		if(!$arg1){
			$this->success();
		}else{
			$this->fail();
		}
	}
	
	function assertInArray($argArray1,$argArray2){
		if(is_array($argArray1) && is_array($argArray2)){
			$success = true;
			
			foreach($argArray1 as $arg1){
				$boolean = false;
				
				foreach($argArray2 as $arg2){
					if($arg1 == $arg2){
						$boolean = true;
						break;
					}
				}
				if(!$boolean){
					$this->fail(sprintf("Result [%s]",$arg1));
					$success = false;
				}
			}
			if($success){
				$this->success();
			}
		}else{
			$this->fail("Bad Argument");
		}
	}

	function assertArgInHash($argId,$argValue,$argHash){
		if(is_array($argHash) && $argId != ""){
			$success = false;
			
			foreach($argHash as $id => $value){
				if($argId == $id){
					if($argValue == $value){
						$success = true;
					}
					break;
				}
			}
			if($success){
				$this->success();
			}else{
				$this->fail(sprintf("Result ID[%s]:VALUE[%s]",$argId,$argValue));				
			}
		}else{
			$this->fail("Bad Argument");
		}		
	}
			
	function success(){
		$this->Logger->debug(sprintf("(%s)SUCCESS",$this->method));
	}
	
	function fail($fail=""){
		if(empty($fail)){
			$fail = "FAIL";
		}
		$this->Logger->error(sprintf("(%s)%s",$this->method,$fail));
	}
	
	function getString($arg){
		ob_start();
			print_r($arg);
			$src = ob_get_contents();
		ob_end_clean();
		
		return  $src;
	}
}
?>