<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagParser.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.2.0
 */
class TemplateParser extends TagParser{
	var $replaceSource	= array();
	var $replaceDesc		= array();

	function addReplace($src,$desc){
		$this->replaceSource[]	= $src;
		$this->replaceDesc[]		= $desc;
	}
	function _systemTemplate($src){
		$tag	= new Tag();
		$value	= "";
		$bool	= false;

		while($tag->set($src,$this->_getTagName("template"))){
			$value	.= $tag->getValue();
			$bool	= true;
			$src	= str_replace($tag->getPlain(),"",$src);
		}
		if($bool){
			return $value;
		}
		return $src;
	}
	function _systemReplace($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("replace"))){
			$src = str_replace($tag->getParameter("src"),$tag->getParameter("desc"),$src);			
			$src = str_replace($tag->getPlain(),"",$src);
		}
		foreach($this->replaceSource as $key => $source){
			$src = str_replace($source,$this->replaceDesc[$key],$src);
		}
		return $src;
	}
	function _systemReplaceFromJs($src){
		if(defined("TEMPLATE_URL")){
			if(preg_match_all("/rhacoTemplate.templateUrl\((.+)\)/",$src,$matchList)){
				foreach($matchList[0] as $key => $match){
					$quote = "'";
					$ｄoublequotePos = strpos($matchList[1][$key],"\"");
					$singlequotePos = strpos($matchList[1][$key],"\'");
	
					if((!($ｄoublequotePos === false) && $ｄoublequotePos < $singlequotePos)){
						$quote = "\"";
					}				
					$src = str_replace($matchList[0][$key],
										sprintf("rhacoTemplate.templateUrl(%s%s%s + %s)",$quote,constant("TEMPLATE_URL"),$quote,$matchList[1][$key]),
										$src
								);
				}
			}
		}
		return $src;
	}
	
	function _systemComment($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("comment"))){
			$src = str_replace($tag->getPlain(),"",$src);
		}
		return $src;
	}

	function _systemReplaceVariable($src){
		if(preg_match_all("/<([\w\d:_-]+)[\s\t].*?var=([\"\'])[^\\2]*?\\2[^>]*?>/i",$src,$tagList)){
			$tagArray	= array();
			$tag			= new Tag();
			$tag	->set($src);
			
			foreach($tagList[1] as $value){
				$tagArray[$value] = $value;
			}
			foreach($tagArray as $name){
				foreach($tag->getIn($name) as $getTag){
					if($getTag->isParameter("var")){
						$plain = $getTag->getPlain();

						$getTag->setValue($getTag->getParameter("var"));
						$getTag->removeParameter("var");						

						$src = str_replace($plain,$getTag->get(),$src);
					}
				}
			}
		}
		return $src;
	}


	function _systemToTagLoop($src){
		if(preg_match_all("/\{#loop\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					$param = "class";
					
					if($counter == 1){		$param = "id";		}
					else if($counter == 2){	$param = "limit";	}						
					else if($counter == 3){	$param = "offset";	}

					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("loop").$val.">",$src);
			}
			$src = str_replace("{#endloop}","</".$this->_getTagName("loop").">",$src);
		}
		return $src;
	}
	function _systemToTagKeyloop($src){
		if(preg_match_all("/\{#keyloop\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					$param = "class";
					
					if($counter == 1){		$param = "key";		}
					else if($counter == 2){	$param = "limit";	}						
					else if($counter == 3){	$param = "offset";	}

					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("loop").$val.">",$src);
			}
			$src = str_replace("{#endkeyloop}","</".$this->_getTagName("loop").">",$src);
		}
		return $src;
	}
	
	function _execLoop($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("loop"))){
			$class	= $this->_parsePlainVariable($tag->getParameter("class","class"));
			$key		= $tag->getParameter("key","key");
			$id		= $tag->getParameter("id","id");
			$counter	= $this->_getVariableString($tag->getParameter("counter","counter"));
			$offset	= $tag->getParameter("offset","1");
			$limit	= $tag->getParameter("limit","0");

			$offsetName		= sprintf("\$_OFFSET_%s",$this->_variableQuote($class));
			$limitName		= sprintf("\$_LIMIT_%s",$this->_variableQuote($class));

			$function	= sprintf("%s%s = 1;%s",$this->_getPhpTagStart(),$counter,$this->_getPhpTagEnd());
			$function	.= sprintf("%s %s = %d;%s",$this->_getPhpTagStart(),$offsetName,$offset,$this->_getPhpTagEnd());
			$function	.= sprintf("%s %s = %d;%s",$this->_getPhpTagStart(),$limitName,(($limit>0)?($offset + $limit):0),$this->_getPhpTagEnd());
			$function	.= sprintf("%sif(is_array(%s)):%s",$this->_getPhpTagStart(),$this->_getVariableString($class),$this->_getPhpTagEnd());
			$function	.= sprintf("%sforeach(%s as %s => %s):%s",$this->_getPhpTagStart(),$this->_getVariableString($class),$this->_getVariableString($key),$this->_getVariableString($id),$this->_getPhpTagEnd());
			$function	.= sprintf("%sif(%s <= %s):%s",$this->_getPhpTagStart(),$offsetName,$counter,$this->_getPhpTagEnd());
			$function	.= sprintf("%s",$tag->getValue());
			$function	.= sprintf("%sendif;%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			$function	.= sprintf("%s%s++;%s",$this->_getPhpTagStart(),$counter,$this->_getPhpTagEnd());
			$function	.= sprintf("%sif(%s > 0 && %s >= %s){break;}%s",$this->_getPhpTagStart(),$limitName,$counter,$limitName,$this->_getPhpTagEnd());
			$function	.= sprintf("%sendforeach;%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			$function	.= sprintf("%sendif;%s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());

			$src = str_replace($tag->getPlain(),$function,$src);
		}		
		return $src;
	}

	function _systemToTagFor($src){
		if(preg_match_all("/\{#for\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					$param = "id";
					
					if($counter == 1){		$param = "start";	}
					else if($counter == 2){	$param = "end";		}						
					else if($counter == 3){	$param = "step";		}

					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("for").$val.">",$src);
			}
			$src = str_replace("{#endfor}","</".$this->_getTagName("for").">",$src);
		}
		return $src;
	}
	
	function _execFor($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("for"))){
			$counterName	= $this->_getVariableString($tag->getParameter("id","counter"));
			$start		= intval($tag->getParameter("start",0));
			$end			= intval($tag->getParameter("end",10));
			$step		= intval($tag->getParameter("step",1));
			
			$function = sprintf("%s for(%s=%d;%s<=%d;%s+=%d): %s\n",
								$this->_getPhpTagStart(),								
								$counterName,
								$start,
								$counterName,
								$end,
								$counterName,
								$step,
								$this->_getPhpTagEnd()
							);
			$function .= $tag->getValue();
			$function .= sprintf("%s endfor; %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			
			$src = str_replace($tag->getPlain(),$function,$src);
		}		
		return $src;
	}
	
	function _systemToTagIf($src){
		if(preg_match_all("/\{#if\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					if($counter == 0){		$param = "target";	}
					else if($counter == 1){	$param = "value";	}						

					$value = preg_replace("/^\"/","",$value);
					$value = preg_replace("/\"$/","",$value);
					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("if").$val.">",$src);
			}
			$src = str_replace("{#else}","<".$this->_getTagName("else")." />",$src);
			$src = str_replace("{#endif}","</".$this->_getTagName("if").">",$src);
		}
		return $src;		
	}
	function _systemToTagIfNot($src){
		if(preg_match_all("/\{#ifnot\((.+)\)\}/i",$src,$matchList)){
			foreach($matchList[0] as $key => $match){
				$val			= "";
				$counter		= 0;

				foreach(split(",",$matchList[1][$key]) as $value){
					if($counter == 0){		$param = "target";	}
					else if($counter == 1){	$param = "value";	}						
					$value = preg_replace("/^\"/","",$value);
					$value = preg_replace("/\"$/","",$value);					

					$val .= sprintf(" %s=\"%s\"",$param,$value);
					$counter++;
				}
				$src = str_replace($matchList[0][$key],"<".$this->_getTagName("ifnot").$val.">",$src);
			}
			$src = str_replace("{#else}","<".$this->_getTagName("else")." />",$src);
			$src = str_replace("{#endifnot}","</".$this->_getTagName("ifnot").">",$src);
		}
		return $src;		
	}

	function _execIf($src){
		$tag = new Tag();
		
		while($tag->set($src,$this->_getTagName("if"))){
			$arg1		= $this->_parsePlainVariable($tag->getParameter("target"));
			$value		= $tag->getValue();
			$pattern		= "";
			$parse		= array();
			
			if(!is_bool($arg1) && !preg_match("/^[\$\'\"]/",$arg1)){
				$arg1 = sprintf("'%s'",$arg1);
			}			
			if($tag->isParameter("value")){
				$arg2 = $this->_parsePlainVariable($tag->getParameter("value"));							
				if(!preg_match("/^([\$\'\"])/",$arg2)){
					$arg2 = sprintf("'%s'",$arg2);
				}
				$pattern = sprintf("%s == %s",$arg1,$arg2);
			}else{
				$pattern = sprintf("%s",$arg1);
			}
			$function	= sprintf("%s if(%s): %s",$this->_getPhpTagStart(),$pattern,$this->_getPhpTagEnd());
			
			if(preg_match("/(<[\s\t]*".$this->_getTagName("else")."[^>]*[\s\t]*\/>)/i",$tag->getValue(),$parse)){
				$value	= str_replace($parse[1],
								sprintf("%s else: %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd()),
								$value
							);
			}
			$function	.= sprintf("%s",$value);
			$function	.= sprintf("%s endif; %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());
			
			$src = str_replace($tag->getPlain(),$function,$src);			
		}
		return $src;
	}
	function _execIfNot($src){
		$tag = new Tag();

		while($tag->set($src,$this->_getTagName("ifnot"))){
			$arg1		= $this->_parsePlainVariable($tag->getParameter("target"));
			$value		= $tag->getValue();
			$pattern		= "";
			$parse		= array();

			if(!is_bool($arg1) && !preg_match("/^([\$\'\"])/",$arg1)){
				$arg1 = sprintf("\"%s\"",$arg1);
			}
			if($tag->isParameter("value")){
				$arg2 = $this->_parsePlainVariable($tag->getParameter("value"));							
				if(!preg_match("/^([\$\'\"])/",$arg2)){
					$arg2 = sprintf("\"%s\"",$arg2);
				}
				$pattern = sprintf("%s != %s",$arg1,$arg2);
			}else{
				$pattern = sprintf("!%s",$arg1);
			}
			$function	= sprintf("%s if(%s): %s",$this->_getPhpTagStart(),$pattern,$this->_getPhpTagEnd());
			
			if(preg_match("/(<[\s\t]*".$this->_getTagName("else")."[^>]*[\s\t]*\/>)/i",$tag->getValue(),$parse)){
				$value	= str_replace($parse[1],
								sprintf("%s else: %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd()),
								$value
							);
			}
			$function	.= sprintf("%s",$value);
			$function	.= sprintf("%s endif; %s",$this->_getPhpTagStart(),$this->_getPhpTagEnd());

			$src = str_replace($tag->getPlain(),$function,$src);
		}
		return $src;
	}
	function _getTagName($value){
		return sprintf("RT:%s",$value);
	}
}
?>