<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.2.1
 */
class TagUtil{ 
	var $FileUtil	= null;

	function TagUtil(){
		$this->FileUtil = new FileUtil();
	}	
	function select($filename,$conditionsTag,$limit=0,$offset=0){
		if($this->_isFile($filename)){
			$resultTagList	= array();
			$tag	 			= new Tag();
			$count			= 0;
			$limit			= $offset + $limit;
	
			if($tag->set($this->FileUtil->fgets($filename))){
				if($this->isTag($conditionsTag)){
					foreach($tag->getIn($conditionsTag->getName()) as $selectTag){
						if($this->completeValidity($selectTag,$conditionsTag)){
							if($offset <= $count){							
								if($limit > 0 && $limit <= $count){
									break;
								}
								$resultTagList[] = $selectTag;
								$count++;
							}
						}
					}
				}else{
					$resultTagList[] = $tag;
				}
			}
			return $resultTagList;
		}
		return false;
	}
	function count($filename,$conditionsTag=null){
		if($this->_isFile($filename)){		
			$tag	= new Tag();
			$count	= 0;
			
			if($tag->set($this->FileUtil->fgets($filename))){
				if($this->isTag($conditionsTag)){
					foreach($tag->getIn($conditionsTag->getName()) as $selectTag){
						if($this->completeValidity($selectTag,$conditionsTag)){
							$count++;
						}
					}
				}
			}
			return $count;
		}
		return false;
	}
	function get($filename,$conditionsTag=null){
		if($this->_isFile($filename)){	
			$resultTagList = $this->select($filename,$conditionsTag);
	
			if(sizeof($resultTagList) != 1){
				return false;
			}
			return $resultTagList[0];
		}
		return false;
	}
	function insert($filename,$insertTag,$conditionsTag=null){
		if($this->_isFile($filename)){
			if($this->isTag($insertTag)){
				$src = $this->FileUtil->fgets($filename);
	
				foreach($this->select($filename,$conditionsTag) as $tag){
					$plain = $tag->getPlain();
					$tag->addValue($insertTag->get()."\n");
					$src = str_replace($plain,$tag->get(),$src);
				}
				return $this->FileUtil->fwrite($filename,$src);
			}
		}
		return false;
	}
	function update($filename,$updateTag,$conditionsTag=null){
		if($this->_isFile($filename)){
			if($this->isTag($updateTag)){
				$src = $this->FileUtil->fgets($filename);
				
				foreach($this->select($filename,$conditionsTag) as $tag){
					$src = str_replace($tag->getPlain(),$updateTag->get(),$src);
				}
				return $this->FileUtil->fwrite($filename,$src);
			}
		}
		return false;
	}
	function delete($filename,$conditionsTag=null){
		if($this->_isFile($filename)){
			$src = $this->FileUtil->fgets($filename);
			
			foreach($this->select($filename,$conditionsTag) as $tag){
				$src = str_replace($tag->getPlain(),"",$src);
			}
			return $this->FileUtil->fwrite($filename,$src);
		}
		return false;
	}
	function setTransaction($bool){
		$this->FileUtil->setTransaction($bool);
	}
	function commit($filename){
		return $this->FileUtil->commit($filename);
	}
	function rollback($filename){
		$this->FileUtil->rollback($filename);
	}
	
	function getIn($tag,$conditionsTag){
		$tagList = array();

		if($tag->getValue() != ""){
			$plain	= $tag->getValue();

			while(true){
				$tmptag	= new Tag();

				if($tmptag->set($plain,$conditionsTag->getName())){
					if($this->validity($tmptag,$conditionsTag)){
						$tagList[] = $tmptag;
					}
					$plain = str_replace($tmptag->getPlain(),"",$plain);
				}else{
					break;
				}
			}
		}
		return $tagList;
	}
	function getNotIn($tag,$conditionsTag){
		$tagList = array();

		if($tag->getValue() != ""){
			$plain	= $tag->getValue();

			while(true){
				$tmptag	= new Tag();

				if($tmptag->set($plain,$conditionsTag->getName())){
					if(!$this->validity($tmptag,$conditionsTag)){
						$tagList[] = $tmptag;
					}
					$plain = str_replace($tmptag->getPlain(),"",$plain);
				}else{
					break;
				}
			}
		}
		return $tagList;
	}
	function isTag($tag){
		if(is_object($tag) && preg_match("/^Tag$/i",get_class($tag))){
			return true;
		}
		return false;
	}
	function isTagfile($filename,$tagname,$create=false){
		$tag	 = new Tag();		
		
		if($tag->set($this->FileUtil->fgets($filename),$tagname)){
			if(preg_match("/".$tag->getName()."/i",$tagname)){
				return true;
			}
		}else if(Variable::getBoolean($create)){
			$newTag = new Tag($tagname);
			return $this->FileUtil->fputs($filename,$newTag->get());
		}
		return false;
	}
	function completeValidity($tag,$conditionsTag){
		if($this->validity($tag,$conditionsTag)){
			$nextTargetTag	= new Tag();
			$nextTag		= new Tag();

			if($nextTargetTag->set($conditionsTag->getValue())){
				foreach($tag->getIn($nextTargetTag->getName()) as $nextTag){
					if($this->completeValidity($nextTag,$nextTargetTag)){
						return true;
					}
				}
				return false;
			}
			return true;
		}
		return false;
	}
	function validity($tag,$conditionsTag){
		if(strtolower($tag->getName()) != strtolower($conditionsTag->getName())){
			return false;
		}
		foreach($conditionsTag->getParameterList() as $parameterId => $param){
			if(!($tag->isParameter($parameterId) &&
				preg_match("/^".$param->getValue()."$/",$tag->getParameter($parameterId))
			)){
				return false;
			}
		}
		foreach($conditionsTag->getAttributeList() as $attributeId => $attribute){
			if(!($tag->isAttribute($attributeId) &&
				preg_match("/^".$attribute."$/",$tag->getAttribute($attributeId))
			)){
				return false;
			}
		}
		$conditionsTagValue = trim(str_replace("\n","",str_replace("\r","",$conditionsTag->getValue())));
		if(!empty($conditionsTagValue)){
			$tagValue = trim(str_replace("\n"," ",str_replace("\r"," ",$tag->getValue())));
			if(empty($tagValue) || (!empty($tagValue) && !preg_match("/^".$conditionsTagValue."$/i",$tagValue))){
				return false;
			}
		}
		return true;
	}
	function sort($tagList,$orderNameArray,$limit=0,$offset=0){
		$count	= 0;
		$limit	= $offset + $limit;
		$tagList = $this->_keyset($tagList,$orderNameArray);
		ksort($tagList);

		if($limit > 0){
			$list = array();
			
			foreach($tagList as $tag){
				if($offset <= $count && $limit >= $count){
					$list[] = $tag;
				}
				$count++;
			}
			$tagList = $list;
		}
		return $tagList;
	}
	function rsort($tagList,$orderNameArray,$limit=0,$offset=0){
		$count	= 0;
		$limit	= $offset + $limit;
		$tagList = $this->_keyset($tagList,$orderNameArray);
		krsort($tagList);

		if($limit > 0){
			$list = array();
			
			foreach($tagList as $tag){
				if($offset <= $count && $limit >= $count){
					$list[] = $tag;
				}
				$count++;
			}
			$tagList = $list;
		}
		return $tagList;
	}
	function simpleQuote($value){
		$value = preg_quote($value,"/¥¥");
		$value = str_replace("_",".",$value);
		$value = str_replace("%",".*",$value);

		return $value;
	}
	function toObject($tag,$object){
		if(is_object($object) && $this->isTag($tag)){
			foreach(get_class_methods($object) as $methodName){
				if(preg_match("/^set(.+)$/i",$methodName,$setter)){
					call_user_func_array(array(&$object,$methodName),array($tag->getParameter($setter[1])));
				}
			}
			return $object;
		}
		return $object;
	}
	function _keyset($tagList,$orderNameArray){
		$resultTagList	= array();
		$nameList		= array();
		$nameSizeList	= array();
		$format			= array();
		$tagSize			= sizeof(strval($tagList));

		foreach($tagList as $id => $tag){
			foreach($orderNameArray as $name){
				if(!isset($nameSizeList[$name])){
					$nameSizeList[$name] = 0;
				}
				$param = $tag->getParameter($name);

				$nameList[$id][$name] = $param;

				if(strlen($param) > $nameSizeList[$name]){
					$nameSizeList[$name] = strlen($param);
					$format[$name] = sprintf("%%'_-%ds%%0%dd",$nameSizeList[$name],$tagSize);
				}
			}
		}
		foreach($nameList as $id => $idList){
			$argName = "";

			foreach($idList as $name => $param){
				$argName .= sprintf($format[$name],$param,$id);
			}
			$resultTagList[$argName] = $tagList[$id];
		}
		return $resultTagList;
	}
	function _isFile($filename){
		if(!empty($filename) && $this->FileUtil->exist($filename)){
			return true;
		}
		return false;
	}
}
?>