<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/Url.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Http.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/VariableExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/TagFormatter.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.8
 */
class TagParser{
	/**	use Define
	 * TEMPLATE_CASH_PATH
	 * TEMPLATE_PATH
	 * TEMPLATE_URL
	 * TEMPLATE_CASH = false;
	*/
	var $Logger		= null;
	var $expiryTime	= 86400;
	var $request		= array();
	var $FileUtil	= null;

	function TagParser(){
		$this->Logger = new Logger($this);
		$this->FileUtil = new FileUtil();
	}
	
	function write($templateFileName,$remotePath="",$request=array()){
		print(StringUtil::encoding($this->read($templateFileName,$remotePath,$request),$this->encodeType));
	}
	function read($templateFileName,$remotePath="",$request=array()){
		$src					= "";
		$templateFileName	= $this->_getTemplatePath($templateFileName);
		$remotePath			= $this->_getTemplateUrl($remotePath);
		$cashFilename		= "";
		$expiryFilename		= "";
		$cashFlag			= false;

		if(defined("TEMPLATE_CASH")){
			$cashFlag = Variable::getBoolean(constant("TEMPLATE_CASH"));
		}
		if(!is_array($request)){
			$request = array($request);
		}
		$request = $this->_setSpecialRequest(array_merge($request,$this->request));
		
		foreach($request as $key => $variable){
			global ${$key};
			${$key} = $variable;
		}
		if($cashFlag && $this->_cash($templateFileName,$remotePath)){
			list($cashFilename,$expiryFilename) = $this->_getCashUrl($templateFileName);

			$this->Logger->debug(sprintf($GLOBALS["RESOURCE"]["READ_CASH_FILE"],$cashFilename));			
			ob_start();
				include($cashFilename);
				$src = ob_get_contents();
			ob_end_clean();
		}else{
			$readsrc = $this->parse($templateFileName,$remotePath);

			if($readsrc == false){
				$this->Logger->warning(sprintf($GLOBALS["RESOURCE"]["FAIL"]["VIEW_FILE"],$templateFileName));
				return false;
			}else{
				$this->Logger->debug(sprintf($GLOBALS["RESOURCE"]["VIEW_FILE"],$templateFileName));
				ob_start();
					eval("?>".stripslashes($readsrc));
					$src = ob_get_contents();
				ob_end_clean();
			}
		}
		return $this->_doRead($this->_unescapeSource($src));
	}

	function parse($templateFileName,$remotePath=""){		
		$src = $this->_getTemplateSource($templateFileName);
		$src = $this->_system($src);
		$src = $this->_exec($src);
		$src = $this->_parsePrintVariable($src);
		$src = Url::parse($src,$remotePath);

		return $this->_escapeSource($src);
	}
	function _escapeSource($src){
		$repList = array();
		
		if(preg_match_all("/<\?([\w\d]+)/",$src,$null)){
			foreach($null[1] as $key => $value){
				$repList[$value] = 1;
			}
			foreach($repList as $key => $value){
				if(strtolower($key) != "php"){
					$src = str_replace(sprintf("<?%s",$key),sprintf("__PHP_TAG_ESCAPE__%s",$key),$src);
				}
			}
		}
		return $src;
	}
	function _unescapeSource($src){
		$src = str_replace("__PHP_TAG_ESCAPE__","<?",$src);
		
		return $src;
	}
	
	function clearCash($templateFileName){
		if(defined("TEMPLATE_CASH")){
			if(Variable::getBoolean(constant("TEMPLATE_CASH"))){
				list($cashFilename,$expiryFilename) = $this->_getCashUrl($this->_getTemplatePath($templateFileName));

				if($this->FileUtil->rm($expiryFilename)){
					if($this->FileUtil->rm($cashFilename)){
						$this->Logger->debug(StringUtil::sprintf($GLOBALS["RESOURCE"]["DELETE_CASH"],$cashFilename));
					}
					$this->Logger->debug(StringUtil::sprintf($GLOBALS["RESOURCE"]["DELETE_CASH"],$expiryFilename));
				}else{
					$this->Logger->debug(StringUtil::sprintf($GLOBALS["RESOURCE"]["FAIL"]["DELETE"],$expiryFilename));
				}
			}
		}
	}	
	function setExpiryTime($time){
		$this->expiryTime = $time;
	}
	function setRequest($array){
		if(!is_array($array)){
			$array = array($array);
		}
		$this->request = $array;
	}

	function _getPhpTagStart(){
		return sprintf("<?php ");
	}
	function _getPhpTagEnd(){
		return sprintf(" ?>");
	}
	function _doRead($src){
		$tagName = array();
		
		foreach(get_class_methods($this) as $methodName){
			if(preg_match("/^_doRead(.+)$/i",$methodName)){
				$src = call_user_func_array(array($this, $methodName),array($src));
			}
			unset($methodName);
		}
		return $src;
	}		
	function _exec($src){
		$tagName = array();

		foreach(get_class_methods($this) as $methodName){
			if(preg_match("/^_exec(.+)$/i",$methodName)){
				$src = call_user_func_array(array($this, $methodName),array($src));
			}
			unset($methodName);
		}
		return $src;
	}
	function _system($src){
		$tagName = array();

		foreach(get_class_methods($this) as $methodName){
			if(preg_match("/^_system(.+)$/i",$methodName)){
				$src = call_user_func_array(array($this, $methodName),array($src));
			}
			unset($methodName);
		}
		return $src;
	}
	function _parsePrintVariable($src){
		$array = $this->_matchVariable($src);

		foreach($array as $variable){
			$src = str_replace($variable,
						sprintf("%sprint(%s);%s",
								$this->_getPhpTagStart(),
								$this->_parsePlainVariable($variable),
								$this->_getPhpTagEnd()
						),
						$src
					);
		}
		unset($array);
		return $src;
	}
	function _parsePlainVariable($src){
		while(true){
			$array = $this->_matchVariable($src);
			
			if(sizeof($array) <= 0){
				break;
			}
			foreach($array as $variable){
				$src = str_replace($variable,substr(str_replace(".","->",$variable),1,-1),$src);
			}
			unset($array,$variable);
		}
		return $src;
	}
	function _matchVariable($src){
		$value			= "";
		$position		= 0;
		$length			= 0;
		$variableHash	= array();
		$variables		= array();
		$src				= preg_replace("/[\r\n\s]/","\t",$src);

		while(preg_match("/({(\\$\w[^\t]+)})/",$src,$variables,PREG_OFFSET_CAPTURE)){
			if($variables[1][0] == ""){	break;	}

			$value		= $variables[1][0];
			$position	= $variables[1][1];
			$length		= strlen($value);

			if(!(strpos($value,"{",1) === false)){
				for($i=0,$start=0,$end=0;$i<strlen($value);$i++){			
					if($value[$i] == "{"){
						$start++;
					}else if($value[$i] == "}"){
						if($start == ++$end){
							$length = $i;
							break;
						}
					}
				}
				$value = substr($value,0,$length+1);
			}
			$src = substr($src,$position + $length);
			$variableHash[sprintf("%03d_%s",$length,$value)] = $value;
		}
		krsort($variableHash);
		unset($src,$variables,$value,$position,$length);
		return $variableHash;
	}
	function _variableQuote($src){
		return preg_replace("/[^\w\d]/","",$src);
	}
	function _getVariableString($src){
		if(substr($src,0,1) == "$"){
			return $src;
		}
		return "\$".$src;
	}

	function _getCashUrl($templateFileName){
		if(!empty($templateFileName)){
			$null = null;
			$templateFileName	= preg_replace("/[¥¥¥:]/","/",$templateFileName);
			$templateFileName	= preg_replace("/[¥~¥&]/","",$templateFileName);
			$base				= str_replace("\\","/",Rhaco::getDefinePath("TEMPLATE_CASH_PATH",Rhaco::path("work")));

			if(!empty($base) && (!(substr($base,-1) == "/" || substr($base,-1) == "\\"))){
				$base = $base."/";
			}
			if(preg_match("/:\/\/([^\/]+)$/",$templateFileName,$null)){
				$templateFileName = sprintf("%s/index",$templateFileName);
			}else if(preg_match("/[\/\\\\]$/",$templateFileName,$null)){
				$templateFileName = sprintf("%sindex",$templateFileName);
			}
			$templateFileName = preg_replace("/[\/]+/","/",$templateFileName);
			if(substr($templateFileName,0,1) == "/"){
				$templateFileName = substr($templateFileName,1);
			}
			return array(sprintf("%scash/%s",$base,$templateFileName),sprintf("%sexpiry/%s",$base,$templateFileName));
		}
		return array(sprintf("%scash/null",$base),sprintf("%sexpiry/null",$base));
	}
	function _getTemplatePath($value){
		return $this->_getDefinePathNormalize("TEMPLATE_PATH",$value);
	}
	function _getTemplateUrl($value=""){
		$url = $this->_getDefinePathNormalize("TEMPLATE_URL",$value);

		if(empty($url)){
			return $this->_getTemplatePath("");
		}
		return $url;
	}
	function _getDefinePathNormalize($defineName,$value){
		$url		= "";
		$null	= null;
		$value	= str_replace("\\","/",$value);
		
		if(preg_match("/^[a-z]\:\//i",$value,$null)){
			$value = str_replace("\\","/",$value);
		}else if(substr($value,0,1) != "/" && !preg_match("/\:\/\//",$value,$null)){
			$url = Rhaco::getDefinePath($defineName);
			if(!empty($url) && substr($url,-1) != "/"){
				$url .= "/";
			}
			$url = str_replace("\\","/",$url);
		}
		return sprintf("%s%s",$url,$value);
	}
	function _cash($templateFileName,$remotePath){	
		list($cashFilename,$expiryFilename)	= $this->_getCashUrl($templateFileName);

		if((!$this->FileUtil->isFile($expiryFilename) || !$this->FileUtil->isFile($cashFilename)) ||
			($this->FileUtil->read($expiryFilename) < mktime()) ||
			(!preg_match("/\:\/\//",$templateFileName) &&
				$this->FileUtil->getUpdateTime($templateFileName) >= $this->FileUtil->getUpdateTime($expiryFilename)
			)
		){
			$src = $this->parse($templateFileName,$remotePath);
			
			if($src == false){
				return false;
			}
			if($this->FileUtil->write($cashFilename,$src)){
				if($this->FileUtil->write($expiryFilename,mktime()+$this->expiryTime)){
					$this->Logger->debug(sprintf($GLOBALS["RESOURCE"]["CREATE_CASH_FILE"],$cashFilename));
					return true;
				}
			}
			$this->Logger->warning(sprintf($GLOBALS["RESOURCE"]["FAIL"]["CREATE_EXPIRY_FILE"],$expiryFilename));
			return false;
		}
		return true;
	}
	function _getTemplateSource($templateFileName){
		$src = "";
		
		if(preg_match("/[\w]+:\/\/[\w]+/",$templateFileName)){
			$src = Http::get($templateFileName);
		}else{
			$src = $this->FileUtil->read($templateFileName);
		}
		return StringUtil::encoding($src,StringUtil::getDetectEncoding());
	}
	
	function _setSpecialRequest($request){
		$request["requests"]		= $request;
		$request["formatter"]		= new TagFormatter();
		$request["rhaco"]		= new Rhaco();		
		$request["errors"]		= array();
		$request["templateurl"]	= "";

		if(defined("TEMPLATE_URL")){
			$request["templateurl"] = Rhaco::templateurl("");
		}
		foreach(VariableExceptionTrigger::getErrors() as $error){
			$request["errors"][] = $error->getMessage();
		}
		return $request;
	}
}
?>