<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
Rhaco::import("tag.data.TagContents");
Rhaco::import("tag.data.Tag");
Rhaco::import("tag.TagUtil");

class TagContentsManager{
	var $tagUtil;
	var $tagfilename;

	function TagContentsManager(){		
		$this->tagUtil		= new TagUtil();		
		$this->tagUtil->setTransaction(true);
	}
	function setDataFile($tagfilename){
		if($this->tagUtil->isTagfile($tagfilename,"data",true)){
			$this->tagfilename	= $tagfilename;
			return true;
		}
		return false;
	}
	function insert($request){
		$tag = $this->_getRequestToTag($request);
		$tag->addParameterValue("id",$this->_getNextId());
		$tag->addParameterValue("registDate",date("YmdHis"));

		if($this->tagUtil->insert($this->tagfilename,$tag)){
			$this->tagUtil->commit($this->tagfilename);
			return true;
		}
		$this->tagUtil->rollback($this->tagfilename);
		return false;		
	}
	function update($request){
		$tag = new Tag("contents");
		$tag->addParameterValue("id",$request["id"]);		

		if($this->tagUtil->update($this->tagfilename,$this->_getRequestToTag($request),$tag)){
			$this->tagUtil->commit($this->tagfilename);
			return true;			
		}
		$this->tagUtil->rollback($this->tagfilename);
		return false;		
	}
	function delete($request){
		$tag = new Tag("contents");
		$tag->addParameterValue("id",$request["id"]);

		if($this->tagUtil->delete($this->tagfilename,$tag)){
			$tag = new Tag("contents");
			$tag->addParameterValue("parentId",$request["id"]);

			if($this->tagUtil->delete($this->tagfilename,$tag)){
				$this->tagUtil->commit($this->tagfilename);
				return true;				
			}
		}
		$this->tagUtil->rollback($this->tagfilename);
		return false;		
	}
	function select($request=array()){
		$list = array();

		$tagList = $this->tagUtil->select($this->tagfilename,$this->_getRequestToConTag($request));
		$tagList = $this->tagUtil->sort($tagList,array("name"));

		foreach($tagList as $contents){
			$object = $this->tagUtil->toObject($contents,new TagContents());
			$object->setValue($contents->getValue());
			$list[] = $object;
		}
		return $list;
	}
	function get($request){
		$tag = new Tag("contents");
		$tag->addParameterValue("id",$request["id"]);
		$tag = $this->tagUtil->get($this->tagfilename,$tag);

		if($tag == false){
			return false;
		}
		return $this->tagUtil->toObject($tag,new TagContents());
	}
	function getParent($request){
		$tag = new Tag("contents");
		$tag->addParameterValue("id",$request["parentId"]);		
		$tag = $this->tagUtil->get($this->tagfilename,$tag);

		if($tag == false){
			return false;
		}
		return $this->tagUtil->toObject($tag,new TagContents());
	}
	function isParent($request){
		return !empty($request["parentId"]);
	}
	
	function _getNextId(){
		$tag	= $this->tagUtil->get($this->tagfilename,new Tag("sequence"));
		if($tag){
			$next	= $tag->getParameter("current") + $tag->getParameter("increment");
			$tag->addParameterValue("current",$next);
			
			$this->tagUtil->update($this->tagfilename,$tag,new Tag("sequence"));
			
			return $next;
		}else{
			$tag = new Tag("sequence");
			$tag->addParameterValue("current",1);
			$tag->addParameterValue("increment",1);			
			
			if($this->tagUtil->insert($this->tagfilename,$tag)){
				$this->tagUtil->commit($this->tagfilename);
			}
			return 1;
		}
	}
	function _getRequestToTag($request){
		$tag = new Tag("contents");

		if($this->_isRequest($request["parentId"])){
			$tag->addParameterValue("parentId",$request["parentId"]);
		}
		if($this->_isRequest($request["id"])){
			$tag->addParameterValue("id",$request["id"]);
		}
		if($this->_isRequest($request["name"])){
			$tag->addParameterValue("name",$request["name"]);
		}
		if($this->_isRequest($request["registDate"])){
			$tag->addParameterValue("registDate",$request["registDate"]);
		}
		if($this->_isRequest($request["data1"])){
			$tag->addParameterValue("data1",$request["data1"]);
		}
		if($this->_isRequest($request["data2"])){
			$tag->addParameterValue("data2",$request["data2"]);
		}
		if($this->_isRequest($request["data3"])){
			$tag->addParameterValue("data3",$request["data3"]);
		}
		if($this->_isRequest($request["data4"])){
			$tag->addParameterValue("data4",$request["data4"]);
		}
		if($this->_isRequest($request["data5"])){
			$tag->addParameterValue("data5",$request["data5"]);
		}
		$tag->addValue($request["value"]);

		return $tag;
	}
	function _getRequestToConTag($request){
		$contentsTag = new Tag("contents");

		if($this->_isRequest($request["parentId"])){
			$contentsTag->addParameterValue("parentId",$request["parentId"]);
		}
		if($this->_isRequest($request["id"])){
			$contentsTag->addParameterValue("id",$request["id"]);
		}
		if($this->_isRequest($request["name"])){
			$contentsTag->addParameterValue("name",$request["name"]);
		}		
		if($this->_isRequest($request["registDate"])){
			$contentsTag->addParameterValue("registDate",$request["registDate"]);
		}
		if($this->_isRequest($request["data1"])){
			$contentsTag->addParameterValue("data1",$request["data1"]);
		}
		if($this->_isRequest($request["data2"])){
			$contentsTag->addParameterValue("data2",$request["data2"]);
		}
		if($this->_isRequest($request["data3"])){
			$contentsTag->addParameterValue("data3",$request["data3"]);
		}
		if($this->_isRequest($request["data4"])){
			$contentsTag->addParameterValue("data4",$request["data4"]);
		}
		if($this->_isRequest($request["data5"])){
			$contentsTag->addParameterValue("data5",$request["data5"]);
		}
		if($this->_isRequest($request["word"])){
			if($request["filterType"] == 1){
				$contentsTag->addParameterValue("name",$this->tagUtil->simpleQuote("%".$request["word"]."%"));
			}else{
				$contentsTag->setValue($this->tagUtil->simpleQuote("%".$request["word"]."%"));
			}
		}
		return $contentsTag;
	}
	function _isRequest($request){
		if(isset($request) && $request != ""){
			return true;
		}
		return false;
	}
}
?>
