<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."Rhaco.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/Url.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TemplateParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/project/Project.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/project/ProjectDefine.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/project/DatabaseModel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/project/TableModel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/project/ColumnModel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/project/ReferenceColumn.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/project/TableDefault.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/DbConnection.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/NotFoundException.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class ProjectParser{
	function parse($filename,$path=""){
		if(!Rhaco::isException()){
			$fileUtil		= new FileUtil();
			$templateParser	= new TemplateParser();
	
			list($request["project"],$databaseList) = $this->_parse($filename,$path);
			$templateParser->clearCash(Rhaco::resource("templates/define.php.template"));
			$templateParser->clearCash(Rhaco::resource("templates/index.php.template"));
			$templateParser->clearCash(Rhaco::resource("templates/local.php.template"));
			$templateParser->clearCash(Rhaco::resource("templates/library/DbConnection.php.template"));
			$templateParser->clearCash(Rhaco::resource("templates/library/data/table/TableObject.php.template"));
			$templateParser->clearCash(Rhaco::resource("templates/library/data/table/TableObject.php.template"));
			$templateParser->clearCash(Rhaco::resource("templates/library/data/verify/VerifyObject.php.template"));
			$templateParser->clearCash(Rhaco::resource("templates/library/data/DataObject.php.template"));
			
			if(!empty($request["project"])){
				$webapppath		= Rhaco::path($request["project"]->webapp);
				
				if($fileUtil->mkdir($webapppath)){
					if(!$fileUtil->exist(Rhaco::path("local.php"))){
						$definepath		= Url::parseRelative(Rhaco::path(),Rhaco::getFilePath($webapppath,"local.php"));
						$defineString	= sprintf("\tinclude_once(\"%s\");\n",$definepath);
		
						if(!$fileUtil->exist(Rhaco::getFilePath($webapppath,"define.php"))){
							$fileUtil->write(
								Rhaco::getFilePath($webapppath,"define.php"),
								$this->_getPhp($defineString)
							);
						}
						if(!$fileUtil->exist(Rhaco::getFilePath($webapppath,"index.php"))){
							$fileUtil->write(
								Rhaco::getFilePath($webapppath,"index.php"),
								$this->_getPhp($templateParser->read(Rhaco::resource("templates/index.php.template"),"",$request))
							);
						}
						if(!$fileUtil->exist(Rhaco::getFilePath($webapppath,"resources/templates/sample.html"))){
							$fileUtil->cp(
								Rhaco::resource("templates/resources/templates/sample.html"),
								Rhaco::getFilePath($webapppath,"resources/templates/")
							);
						}
					}
					$fileUtil->write(
						Rhaco::getFilePath(Rhaco::path(),"local.php"),
						$this->_getPhp($templateParser->read(Rhaco::resource("templates/local.php.template"),"",$request))
					);
					foreach($request["project"]->directoryList as $path => $permission){
						$fileUtil->mkdir(Url::parseAbsolute($webapppath,$path),$permission);
					}
				}
				$fileUtil->mkdir(Rhaco::path("library"),$permission);			
			}
			
			foreach($databaseList as $db){
				$request["database"] = $db;
				
				if(Rhaco::getFilePath(LIBRARY_PATH,"data")){
					$fileUtil->write(
						Rhaco::getFilePath(LIBRARY_PATH,sprintf("data/DbConnection%s.php",$db->method)),
						$this->_getPhp($templateParser->read(Rhaco::resource("templates/library/DbConnection.php.template"),"",$request))
					);
					foreach($db->tableList as $table){
						$request["table"] = $table;
	
						$fileUtil->write(
							Rhaco::getFilePath(LIBRARY_PATH,sprintf("data/table/%sTable.php",$table->method)),
							$this->_getPhp($templateParser->read(Rhaco::resource("templates/library/data/table/TableObject.php.template"),"",$request))
						);
						$fileUtil->write(
							Rhaco::getFilePath(LIBRARY_PATH,sprintf("data/table/%sTableVerify.php",$table->method)),
							$this->_getPhp($templateParser->read(Rhaco::resource("templates/library/data/table/TableVerifyObject.php.template"),"",$request))
						);
	
						if(!$fileUtil->exist(Rhaco::getFilePath(LIBRARY_PATH,sprintf("data/verify/%sVerify.php",$table->method)))){
							$fileUtil->write(
								Rhaco::getFilePath(LIBRARY_PATH,sprintf("data/verify/%sVerify.php",$table->method)),
								$this->_getPhp($templateParser->read(Rhaco::resource("templates/library/data/verify/VerifyObject.php.template"),"",$request))
							);
						}
						if(!$fileUtil->exist(Rhaco::getFilePath(LIBRARY_PATH,sprintf("data/%s.php",$table->method)))){
							$fileUtil->write(
								Rhaco::getFilePath(LIBRARY_PATH,sprintf("data/%s.php",$table->method)),
								$this->_getPhp($templateParser->read(Rhaco::resource("templates/library/data/DataObject.php.template"),"",$request))
							);
						}
					}
				}
			}
			return true;
		}
		return false;
	}
	function dbforward($filename,$path=""){
		if(!Rhaco::isException()){		
			$fileUtil		= new FileUtil();
			$templateParser	= new TemplateParser();
			$sql				= "";
			
			list($project,$databaseList) = $this->_parse($filename,$path);
			unset($project);
	
			foreach($databaseList as $database){
				$sql = "";
				
				if(preg_match("/^DatabaseModel$/i",get_class($database))){
					$con	 = new DbConnection();
				
					$con->setHost($database->host);
					$con->setName($database->name);
					$con->setPassword($database->password);
					$con->setPort($database->port);
					$con->setType($database->type);
					$con->setUser($database->user);
		
					$dbUtil	= new ExtDbUtil($con,false);
					$sql		.= $dbUtil->forward($database);
				}
				if(!empty($sql) && empty($GLOBALS["EXCEPTION"])){
					$fileUtil->write(Rhaco::path(sprintf("setup/database/%s.sql",$database->name)),$sql);
				}
			}
		}
		return false;
	}

	function _parse($filename,$path=""){
		if(empty($filename)){
			return array();
		}
		if(empty($path)){
			$path = Rhaco::path("");
		}
		$fileUtil		= new FileUtil();
		$tag				= new Tag();
		$filename		= Url::parseAbsolute($path,$filename);
		$src				= $fileUtil->read($filename);
		
		if(!$src){
			ExceptionTrigger::error(new NotFoundException($this,"NOT FOUND",$filename));
		}
		$rhacopath		= constant("RHACO_DIR");
		$databaseList	= array();
		
		if($tag->set($src,"rhaco")){
			$rhacopath = $tag->getParameter("path",constant("RHACO_DIR"));
		}
		if($tag->set($this->_import($src,"project",$filename),"project")){
			$project = $this->_parseProject($tag,$rhacopath);
		}
		while(true){
			$src = $this->_import($src,"database",$filename);

			$databaseTag = new Tag();
			if($databaseTag->set($src,"database")){
				$datbase = $this->_parseDatabsse($databaseTag);
				$databaseList[$database->class] = $datbase;

				$src = str_replace($databaseTag->getPlain(),"",$src);
			}else{
				break;
			}
		}
		return array($project,$databaseList);
	}
	function _parseProject($tag,$rhacopath){
		$project				= new Project();
		$project->rhacopath	= Rhaco::getFilePath($rhacopath);
		$project->name		= trim($tag->getParameter("name","project"));
		$project->url		= Rhaco::getFilePath($tag->getParameter("url","http://localhost"));
		$project->path		= trim($tag->getParameter("path",Rhaco::path()));
		$project->webapp		= "";
		$project->webapppath	= Rhaco::path($project->webapp);

		if($tag->isParameter("webapp")){
			$project->webapp = trim($tag->getParameter("webapp"));
		}
		if(!empty($project->webapp)){
			if(preg_match("/^[^\/].+$/",$project->webapp)){
				$project->webapp = "/".$project->webapp;
			}
		}		
		foreach($tag->getIn("rhaco:defineLogHtml") as $rhacoTag){
			$project->defineLogHtml = $rhacoTag->getParameter("value","true");
		}			
		foreach($tag->getIn("rhaco:defineLogFileLevel") as $rhacoTag){
			$project->defineLogFileLevel = $rhacoTag->getParameter("value","none");
		}
		foreach($tag->getIn("rhaco:defineLogSysLevel") as $rhacoTag){
			$project->defineLogSysLevel = $rhacoTag->getParameter("value","none");
		}
		foreach($tag->getIn("rhaco:defineLogDispLevel") as $rhacoTag){
			$project->defineLogDispLevel = $rhacoTag->getParameter("value","none");
		}
		foreach($tag->getIn("rhaco:defineLogFilePath") as $rhacoTag){
			$project->defineLogFilePath = Rhaco::getFilePath($rhacoTag->getParameter("value",Rhaco::path("log")));
		}
		foreach($tag->getIn("rhaco:defineTemplateCash") as $rhacoTag){
			$project->defineTemplateCash = $rhacoTag->getParameter("value","false");
		}
		foreach($tag->getIn("rhaco:define") as $rhacoTag){
			$project->defineList[] = new ProjectDefine($rhacoTag->getParameter("name","NAME"),$rhacoTag->getParameter("value",""));
		}
		foreach($tag->getIn("rhaco:mkdir") as $rhacoTag){
			$project->directoryList[$rhacoTag->getParameter("path")] = $rhacoTag->getParameter("permission");
		}
		return $project;
	}
	function _parseDatabsse($databaseTag){
		$database				= new DatabaseModel();
		$database->name			= trim($databaseTag->getParameter("name"));
		$database->user			= trim($databaseTag->getParameter("user"));
		$database->class			= trim($databaseTag->getParameter("class",$database->name));
		$database->host			= trim($databaseTag->getParameter("host"));			
		$database->password		= trim($databaseTag->getParameter("password"));
		$database->port			= trim($databaseTag->getParameter("port"));
		$database->encode		= trim($databaseTag->getParameter("encode"));
		$database->type			= trim($databaseTag->getParameter("type","MySQL"));
		$database->method		= $this->_getMethodName($database->class);
		$database->prefix		= trim($databaseTag->getParameter("prefix"));
		$database->tableList	= array();

		$con	 = new DbConnection();
	
		$con->setHost($database->host);
		$con->setName($database->name);
		$con->setPassword($database->password);
		$con->setPort($database->port);
		$con->setType($database->type);
		$con->setUser($database->user);

		$dbUtil	= new ExtDbUtil($con,false);
		
		foreach($databaseTag->getIn("table") as $tableTag){
			$table = $this->_parseTable($tableTag,$database->getPrefix());
			$database->tableList[$table->class] = $table;
		}
		foreach($database->tableList as $class => $table){
			foreach($table->referenceList as $key => $reference){
				$database->tableList[$class]->referenceList[$key]->referenceTableReal = $this->_getReferenceTableReal($reference,$database->tableList);
			}			
		}
		foreach($databaseTag->getIn("default") as $tableTag){
			$tableName	= strtoupper(trim($tableTag->getParameter("class")));
			$counter	= 0;
						
			if(!isset($database->tableList[$tableName])){
				ExceptionTrigger::error(new NotFoundException($this,"NOT FOUND",$tableName));
			}else{
				foreach($tableTag->getIn("data") as $dataTag){
					$database->tableList[$tableName]->defaultList[$counter] = array();

					foreach($dataTag->getIn("column") as $columnTag){
						$columnName = strtoupper($columnTag->getParameter("name"));

						if(!isset($database->tableList[$tableName]->columnList[$columnName])){
							ExceptionTrigger::error(new NotFoundException($this,"NOT FOUND",$columnName));							
						}else{
							$database->tableList[$tableName]->defaultList[$counter][] = new TableDefault($columnName,$columnTag->getParameter("value"));
						}
					}
					$counter++;
				}
			}
		}
		return $database;
	}
	function _getReferenceTableReal($reference,$tableList){
		foreach($tableList as $class => $table){
			if($reference->referenceClass == $class){
				foreach($table->columnList as $column){
					if($reference->referenceColumn == $column->name){								
						return $table->name;
					}
				}
				break;
			}
		}
		ExceptionTrigger::error(new NotFoundException($this,"NOT FOUND",$reference->referenceClass));
		return "";
	}
	function _parseTable($tableTag,$prefix=""){
		$table				= new TableModel();
		$name				= trim($tableTag->getParameter("name"));
		$table->name			= strtoupper(sprintf("%s%s",$prefix,$name));
		$table->class		= strtoupper(trim($tableTag->getParameter("class",$name)));				
		$table->method		= $this->_getMethodName($table->class);
		$table->istable 		= "true";
		$table->primaryList	= array();
		$table->columnList	= array();
		$table->referenceList	= array();
		
		foreach($tableTag->getIn("column") as $columnTag){
			$column = $this->_parseColumn($columnTag,$table->primaryList);
			$table->columnList[$column->name] = $column;
		}
		foreach($tableTag->getIn("reference") as $columnTag){
			$reference			= $this->_parseReferenceColumn($columnTag);
			$reference->table	= $table->name;
			$bool				= false;
						
			foreach($table->columnList as $column){
				if($column->name == $reference->column){
					$bool = true;
					break;
				}
			}
			if(!$bool){
				ExceptionTrigger::error(new NotFoundException($this,"NOT FOUND",$reference->column));
			}else{
				$table->referenceList[$reference->column] = $reference;
			}
		}
		return $table;
	}
	function _parseColumn($columnTag,&$primaryList){
		$column				= new ColumnModel();
		$column->name		= strtoupper(trim($columnTag->getParameter("name")));
		$column->type		= $this->_getType($columnTag->getParameter("type"));
		$column->primary		= Variable::getBoolean($columnTag->getParameter("primary","false"));
		$column->default		= $columnTag->getParameter("default","null");
		$column->size		= $this->_getSize($columnTag->getParameter("size"));
		$column->require		= Variable::getBoolean($columnTag->getParameter("require","false"));
		$column->variable	= $this->_getVariableName($column->name);
		$column->method		= $this->_getMethodName($column->name);

		if($column->primary){
			$column->require = false;							
			$primaryList[$column->name] = $column;
		}
		
		if($column->default != "null"){
			switch($column->type){
				case "STRING":
				case "TIMESTAMP":
					$column->default = sprintf("\"%s\"",$column->default);
			}
		}else{
			$column->default = "";
		}
		return $column;
	}
	function _parseReferenceColumn($columnTag){
		$reference = new ReferenceColumn();

		$reference->referenceClass		= trim($columnTag->getParameter("referenceClass"));
		$reference->referenceColumn		= trim($columnTag->getParameter("referenceColumn"));
		$reference->column				= trim($columnTag->getParameter("column"));
		$reference->methodTable			= $this->_getMethodName($reference->referenceClass);
		$reference->methodColumn			= $this->_getMethodName($reference->referenceColumn);
		$reference->method				= $this->_getMethodName($reference->column);
		$reference->referenceTableReal	= $reference->referenceClass;

		return $reference;
	}

	function _import($src,$tagName,$filename){
		$tag 		= new Tag();
		$fileUtil	= new FileUtil();

		if($tag->set($src,$tagName)){
			while(true){
				$importList = $tag->getIn("import");

				if(count($importList) <= 0){
					break;
				}else{
					foreach($importList as $importTag){
						$src = str_replace(
									$importTag->getPlain(),
									$replace = $fileUtil->read(Url::parseAbsolute($filename,$importTag->getParameter("href"))),
									$src
								);
					}
					$tag->set($src,$tagName);
				}
			}
		}
		return $src;
	}
	function _getMethodName($value){
		$method = "";
		
		foreach(split("_",$value) as $name){
			$method = $method.ucwords(strtolower($name));
		}
		return trim($method);
	}
	function _getPhp($value){
		return sprintf("<?php\n%s\n?>",$value);
	}
	function _getVariableName($value){
		$value = $this->_getMethodName($value);
		
		return strtolower(substr($value,0,1)).substr($value,1);
	}
	function _getType($value){
		if(preg_match("/str/i",$value)){
			return "STRING";
		}else if(preg_match("/int/i",$value)){
			return "INTEGER";
		}else if(preg_match("/date/i",$value)){
			return "TIMESTAMP";
		}else if(preg_match("/time/i",$value)){
			return "TIMESTAMP";
		}else if(preg_match("/serial/i",$value)){
			return "SERIAL";
		}else if(preg_match("/bool/i",$value)){
			return "BOOLEAN";
		}
		return "STRING";
	}
	function _getSize($value){
		$size = preg_replace("/[^0-9]/","",$value);
		return intval($size);
	}
}
?>