if(typeof(Rhaco) == 'undefined'){
	Rhaco = function(){};
}

/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
Rhaco.XMLHTTP = function(){
	var xmlHttpRequest	= false;
	var source			= "";
	var status			= 0;

	/** status
	 -1:error
	  0:null
	  1:request
	  2:result
	*/

	Rhaco.XMLHTTP.prototype.get				= get;
	Rhaco.XMLHTTP.prototype.getSource			= getSource;
	Rhaco.XMLHTTP.prototype.isStatusError		= isStatusError;
	Rhaco.XMLHTTP.prototype.isStatusComplete	= isStatusComplete;
	Rhaco.XMLHTTP.prototype.isStatusRedy		= isStatusRedy;

	function get(){
		var url			= "";
		var method		= "get";
		var postdata		= "";

		if(arguments.length > 0){	url 		= arguments[0];	}
		if(arguments.length > 1){	method	= arguments[1];	}
		if(arguments.length > 2){	postdata	= arguments[2];	}
	
	    if(window.ActiveXObject){
			xmlHttpRequest = new ActiveXObject("Microsoft.XMLHTTP");
	    }else if(window.XMLHttpRequest){
			xmlHttpRequest = new XMLHttpRequest();
	    }
		if(xmlHttpRequest){
			status = 1;

			xmlHttpRequest.onreadystatechange = open;

			if(method.match(/post/i)){
				xmlHttpRequest.open('POST',encodeURI(url),true);
				xmlhttp.setRequestHeader("Content-Type" , "application/x-www-form-urlencoded");
				xmlHttpRequest.send(postdata);
			}else{
				if(postdata != ""){
					url = url + "?" + postdata;
				}
				xmlHttpRequest.open('GET',encodeURI(url),true);
				xmlHttpRequest.send(null);
			}
		}else{
			status = -1;
		}
	}

	function open(){
		if(xmlHttpRequest){
			if(xmlHttpRequest.readyState == 4){ 
				if(xmlHttpRequest.responseText){
					source = xmlHttpRequest.responseText;
					status = 2;
				}else{
					status = -1;
				}
			}
		}
	}
	
	function getSource(){
		return source;
	}

	function isStatusError(){
		if(status == -1){
			status = 0;		
			return true;
		}
		return false;
	}
	
	function isStatusRedy(){
		if(status == 1){
			return true;
		}
		return false;
	}
	function isStatusComplete(){
		if(status == 2){
			status = 0;
			return true;
		}
		return false;
	}
}
