<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version develop
 */
include_once(dirname(__FILE__)."/Rhaco.php");
Rhaco::import("tag.ProjectParser");
Rhaco::import("resources.Resource_EN");

Rhaco::defineContextRoot(getcwd());
Rhaco::defineLibraryPath();
Rhaco::defineTemplateCash(false);

$projectParser = new ProjectParser();
	
if(sizeof($argv) <= 1){
	message();
}else if(sizeof($argv) == 2){
	$projectParser->parse($argv[1]);
	$projectParser->dbforward($argv[1]);
}else if(sizeof($argv) == 3){
	if(preg_match("/^\-[fg]+/",$argv[1])){
		if(strpos($argv[1],"g")){
			$projectParser->parse($argv[1]);
		}
		if(strpos($argv[1],"f")){
			$projectParser->dbforward($argv[1]);
		}
	}else{
		message();			
	}
}
if(Rhaco::isException()){
	print("------------------------------------------\n");		
	foreach(Rhaco::exceptions() as $exceptions){		
		foreach($exceptions as $exception){
			print($exception->getMessage()."\n");
		}
	}
	print("------------------------------------------\n");		
}
function message(){
	print("------------------------------------------\n");	
	print("php -C project.php [-r] projectXmlFilename\n");
	print("-g generate project\n");
	print("-f forward database\n");
	print("------------------------------------------\n");	
	exit;
}
//print_r($GLOBALS["EXCEPTION"]);
?>