<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/Url.php");
/**
 * @author Makoto Tsuyuki
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.8.0
 */
class TrackbackPing {
	var $title = "";
	var $excerpt = "";
	var $url = "";
	var $blogName = "";	
	var $entryUrl = "";
	var $timeout = 0;
	
	function TrackbackPing($in_timeout = 15) {
		$this->timeout = $in_timeout;
	}
	
	function setTitle($in_title) {
		$this->title = $in_title;
	}
	
	function setExcerpt($in_excerpt) {
		$this->excerpt = $in_excerpt;
	}
	
	function setUrl($in_url) {
		$this->url = $in_url;
		$urlHash = parse_url($this->url);
		$this->targetHost = $urlHash["host"];
		$this->targetPath = $urlHash["path"];
		if(isset($urlHash["port"])) $this->targetPort = $urlHash["port"];
	}
	
	function setBlogName($in_blogName) {
		$this->blogName = $in_blogName;
	}
	
	function setEntryUrl($in_entryUrl) {
		$this->entryUrl = $in_entryUrl;
	}
	

	function ping() {
		if(empty($this->url) || empty($this->entryUrl)) return false;
		$Url = new Url();
		$rawQuery = array('title'=>$this->title,
		                  'excerpt'=>$this->excerpt,
				  'url'=>$this->entryUrl,
				  'blog_name'=>$this->blogName);
		return $Url->get($this->url, "POST", $rawQuery, "",$this->timeout);
	}
		
}
?>
