<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");

/**
 * @author Makoto Tsuyuki
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.8.0
 */
class Trackback {
	var $title = "";
	var $excerpt = "";
	var $url = "";
	var $blogName = "";
	var $path_info = "";
	var $ip = "";
	var $charset = "";

	function Trackback($in_charset = "Shift_JIS") {
		$this->charset = $in_charset;
		$this->title     = $_POST["title"];
		$this->excerpt   = $_POST["excerpt"];
		$this->url       = $_POST["url"];
		if(empty($this->title) || $this->title == "") $this->title = $this->url;
		$this->blogName  = $_POST["blog_name"];
		$this->path_info = $_SERVER['PATH_INFO'];
		$this->ip        = $_SERVER['REMOTE_ADDR'];
	}

	function getTrackbackTargetId() {
		return substr($this->path_info, strrpos($this->path_info, "/") + 1, strlen($this->path_info));
	}
	
	function charConv($in) {
		if(empty($in)) {
			return "";
		}
		return StringUtil::encoding($in,"SJIS");
	}

	function isValid() {
		if(empty($this->url) || trim($this->url) == "") return false;
		return true;
	}
	
	function getTitle() {
		return $this->title;
	}
	function getExcerpt() {
		return $this->excerpt;
	}
	function getUrl() {
		return $this->url;
	}
	function getPathInfo() {
		return $this->path_info;
	}
	function getIp() {
		return $this->ip;
	}
	function getBlogName() {
		return $this->blogName;
	}
}
?>
