<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/mail/data/Mail.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version develop
 */
class MailUtil{
	var $xMailer	= "Rhacophorus";
	var $mime		= "1.0";
	var $boundary;

	var $CONTENT_TYPE_HTML = "text/html";
	var $CONTENT_TYPE_TEXT = "text/plain";

	function send($mail){
		$subject	= "";
		$body		= "";
		$head		= "";

		if(sizeof($this->attachedFile) > 0 || sizeof($this->attachedHtml) > 0){
			if(empty($boundary)){
				$boundary = "----=_MultiPart_".uniqId("auto");
			}
			$headers["Content-Type"]	= "multipart/mixed; boundary=\"".$boundary."\"";

			if(sizeof($this->attachedHtml) > 0){
				$boundary = "----=_MultiPartHtml_".uniqId("auto");

				$body .= "This is a multi-part message in MIME format.\n";
				$body .= "--".$boundary."\n";
				$body .= "Content-Type: multipart/alternative; boundary=\"".$boundary."\"\n";
				$body .= "\n\n";

				$body .= "--".$boundary."\n";
				$body .= "Content-Type: text/plain; charset=\"iso-2022-jp\"\n";
				$body .= "Content-Transfer-Encoding: 7bit\n";
				$body .= "\n";
				$body .= $this->body;
				$body .= "\n";

				foreach($this->attachedHtml as $attachedFile){
					$body .= "--".$boundary."\n";

					$body .= "Content-Type: text/html; charset=\"iso-2022-jp\"\n";
					$body .= "Content-Transfer-Encoding: 7bit\n";
					$body .= "\n";

					$attachedFile->contents = str_replace("\0","",$attachedFile->contents);

					//UTF-8 BOM
					if(ord($attachedFile->contents[0]) == 239  &&
						ord($attachedFile->contents[1]) == 187  &&
						ord($attachedFile->contents[2]) == 191
					){
						$attachedFile->contents = substr($attachedFile->contents,2);
					}
					$body .= $attachedFile->contents;
				}
				$body .= "\n";
				$body .= "--".$boundary."--\n";
				$body .= "\n";
			}else{
				$body .= "--".$boundary."\n";
				$body .= "Content-Type: text/plain; charset=\"iso-2022-jp\"\n";
				$body .= "Content-Transfer-Encoding: 7bit\n";
				$body .= $this->body;
				$body .= "\n";
			}
			if(sizeof($this->attachedFile) > 0){
				foreach($this->attachedFile as $attachedFile){
					$body .= "--".$boundary."\n";
					$body .= "Content-Type: ".$attachedFile->type."; name=\"".$attachedFile->filename."\n";
					$body .= "Content-Transfer-Encoding: base64\n";
					$body .= "Content-Disposition: attachment; filename=\"".$attachedFile->filename."\"\n";
					$body .= chunk_split(base64_encode($attachedFile->contents));
					$body .= "\n";
				}
			}
			$body .= "--" .$boundary ."--\n";
		}else{
			$headers["Content-Type"]				= "text/plain; charset=\"ISO-2022-JP\"";
			$headers["Content-Transfer-Encoding"]	= "7bit";
			$body .= $this->body;
		}

		if(!empty($this->cc)){		$headers["Cc"]					= $this->cc;			}
		if(!empty($this->bcc)){		$headers["Bcc"]					= $this->bcc;			}
		if(!empty($this->replyTo)){	$headers["Reply-To"]			= $this->replayTo;		}
		if(!empty($this->errorTo)){	$headers["Errors-To"]			= $this->errorTo;		}
		if(!empty($this->mime)){	$headers["Mime-Version"]		= $this->mime;			}
		if(!empty($this->xMailer)){	$headers["X-Mailer"]			= $this->xMailer;		}

		if(!empty($this->fromName)){
			if(mb_detect_encoding($this->fromName) != 'ASCII'){
				$this->fromName = mb_encode_mimeheader($this->fromName);
			}
			$headers["From"]	= sprintf("\"%s\" <%s>",$this->fromName,$this->from);
		}else{
			$headers["From"]	= $this->from;
		}

		if(!empty($headers["Reply-To"])){		$head .= sprintf("Reply-To: %s\n",$headers["Reply-To"]);		}
		if(!empty($headers["Errors-To"])){		$head .= sprintf("Errors-To: %s\n",$headers["Errors-To"]);		}
		if(!empty($headers["X-Mailer"])){		$head .= sprintf("X-Mailer: %s\n",$headers["X-Mailer"]);		}
		if(!empty($headers["From"])){			$head .= sprintf("From: %s\n",$headers["From"]);				}
		if(!empty($headers["Mime-Version"])){	$head .= sprintf("Mime-Version: %s\n",$headers["Mime-Version"]);	}
		if(!empty($headers["Content-Type"])){	$head .= sprintf("Content-Type: %s\n",$headers["Content-Type"]);	}
		if(!empty($headers["Content-Transfer-Encoding"])){	$head .= sprintf("Content-Transfer-Encoding: %s\n",$headers["Content-Transfer-Encoding"]);	}
		if(!empty($headers["Cc"])){				$head .= sprintf("cc: %s\n",$headers["cc"]);					}
		if(!empty($headers["Bcc"])){			$head .= sprintf("bcc: %s\n",$headers["bcc"]);					}

		if(preg_match("/.*\.exe$/i",$_SERVER["SCRIPT_FILENAME"])){
			$body = str_replace("\n","\r\n",str_replace("\r","",$body));
		}else{
			$body = str_replace("\r","",$body);
		}

		$subject	= mb_encode_mimeheader(preg_replace("[\r\n]","",$this->subject));
		$this->body	= StringUtil::encoding($body,"JIS",$language);
		$returnPath	= "";
		
		if(!empty($this->returnPath)){
			$returnPath = sprintf(" -f%s",$this->returnPath);
		}
		return mail($this->to,$subject,$this->body,$head,$returnPath);
	}

	function read($mailText){
		$mailText	= StringUtil::encoding($mailText,"UTF-8");
		$mail		= new Mail();
		
		$this->_getBody($mailText);

		$this->_getSubject($this->head);
		$this->_getFrom($this->head);
		$this->_getTo($this->head);
		$this->_getReplyTo($this->head);
		$this->_getReturnPath($this->head);

		return $mail;
	}


	function _getBody($mailText){
		$boundary		= md5(uniqid(""));
		$contentsType	= array();
		$bodyArray		= array();
		$body			= "";
		$head			= "";

		list($head,$body) = spliti("content-type",$mailText,2);
		
		if(preg_match("/Content-type:.*multipart/i",$mailText)){
			if(preg_match("/boundary=\"([^\"]+)\"/i",$mailText,$value)){
				$boundary = $value[1];
			}
		}
		$bodyArray = split("--".$boundary,"content-type".$body);

		foreach($bodyArray as $body){
			list($head,$body)	= explode("\n\n",$body,2);
			$filename			= array();

			if(eregi("Content-type: *([^;\n]+)",$head,$contentsType)){
				$contentsType = strtolower($contentsType[1]);

				if($contentsType == "multipart/mixed"){
				}else if($contentsType == $this->CONTENT_TYPE_TEXT){
					$this->body = StringUtil::encoding($body,"SJIS");
				}else{
					$structAtachedFile = new MailAttachedFile();

					if(eregi("name=\"?([^\"\n]+)\"?",$head,$filename)){
						$structAtachedFile->filename = ereg_replace("[\t\r\n]", "",$filename[1]);

						if(eregi("(.*)=\?iso-2022-jp\?B\?([^\?]+)\?=(.*)",$structAtachedFile->filename,$filename)){
							$structAtachedFile->filename = $filename[1].base64_decode($filename[2]).$filename[3];
						}
					}
					$structAtachedFile->filename = StringUtil::encoding($structAtachedFile->filename,"SJIS");
					$structAtachedFile->contents = base64_decode(str_replace("\n","",$body));

					$this->attachedFile[] = $structAtachedFile;
				}
			}
		}
	}
	function _getSubject($mailText){
		$subjectArray	= array();
		$regs			= array();

		if(eregi("\nSubject:[ \t]*([^\n]+)", $mailText,$subjectArray)){
			$subject = $subjectArray[1];

			while(eregi("(.*)=\?iso-2022-jp\?B\?([^\?]+)\?=(.*)",$subject,$regs)){
				$subject = $regs[1].base64_decode($regs[2]).$regs[3];
			}
			while(eregi("(.*)=\?iso-2022-jp\?Q\?([^\?]+)\?=(.*)",$subject,$regs)){
				$subject = $regs[1].quoted_printable_decode($regs[2]).$regs[3];
			}
	    }
		$this->subject = StringUtil::encoding($subject,"SJIS");
	}

	function _getFrom($mailText){
		if(preg_match("/From:[ \t]*([^\n]+)/i",$mailText,$value)){
			return $value[1];
		}
		return "";
	}
	function _getTo($mailText){
		if(preg_match("/To:[ \t]*([^\n]+)/i",$mailText,$value)){
			return $value[1];
		}
		return "";
	}
	function _getReplyTo($mailText){
		if(preg_match("/Reply-To:[ \t]*([^\n]+)/i",$mailText,$value)){
			return $value[1];
		}
		return "";
	}
	function _getReturnPath($mailText){
		if(preg_match("/Return-Path:[\s\t]*([^\n]+)/i",$mailText,$value)){
			return $value[1];
		}
		return "";
	}
	
}
?>