<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");

/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.7.0
 */
class RdfItem{
	var $about = "";
	var $title = "";
	var $link = "";
	var $description = "";

	function RdfItem($title,$description="",$link="",$about=""){
		$this->setAbout($about);
		$this->setTitle($title);
		$this->setLink($link);
		$this->setDescription($description);
	}
	
	function getTag(){
		$titleTag		= new Tag("title",$this->getTitle());		
		$linkTag		= new Tag("link",$this->getLink());		
		$descriptionTag	= new Tag("description",$this->getTitle());
		$encodedTag		= new Tag("content:encoded");

		$itemTag		= new Tag("item");
		$itemValue		= "\n";
		$itemValue		.= $titleTag->get()."\n";
		$itemValue		.= $linkTag->get()."\n";
		$itemValue		.= $descriptionTag->get()."\n";	
		$itemValue		.= $encodedTag->get()."\n";

		$itemTag->addParameterValue("rdf:about",$this->getAbout());
		$itemTag->setValue($itemValue);
		
		return $itemTag->get();
	}

	function setAbout($value){
		$this->about = $value;
	}
	function getAbout(){
		return $this->about;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setLink($value){
		$this->link = $value;
	}
	function getLink(){
		return $this->link;
	}	
	function setDescription($value){
		$this->description = $value;
	}
	function getDescription(){
		return $this->description;
	}
}