<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/rdf/RdfItem.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.7.0
 */
class Rdf{
	var $lang		= "ja";
	var $encoding	= "UTF-8";
	var $about		= "";
	var $title		= "";
	var $link		= "";
	var $description = "";
	
	var $itemList = array();

	function Rdf($title="",$description="",$link="",$about=""){
		$this->set($title,$description,$link,$about);
	}
	function set($title,$description="",$link="",$about=""){
		$this->setAbout($about);
		$this->setTitle($title);
		$this->setLink($link);
		$this->setDescription($description);
		
		$this->itemList = array();
	}
	function open($RdfUrl){
		$fileUtil = new FileUtil();
		$rdfSource = $fileUtil->read($RdfUrl,$this->getEncoding());

		if(!empty($rdfSource)){
			return $this->parse($rdfSource);
		}
		return false;
	}	
	function parse($rdfSource){
		$Tag		= new Tag();
		$rdfTag	= new Tag();

		if($rdfTag->set($rdfSource,"rdf:RDF")){
			$channelTag = new Tag();
			$channelTag->set($rdfTag ->getValue(),"channel");
			$about		= $channelTag->getParameter("rdf:about");
			
			$Tag->set($channelTag->getValue(),"title");
			$title	= $Tag->getValue();
	
			$Tag->set($channelTag->getValue(),"link");
			$link	= $Tag->getValue();
	
			$Tag->set($channelTag->getValue(),"description");
			$description	= $Tag->getValue();
	
			$this->set($title,$description,$link,$about);
			
			$itemList = $rdfTag->getIn("item");
			
			foreach($itemList as $item){
				$about	= $item->getParameter("rdf:about");
	
				$Tag->set($item->getValue(),"title");
				$title	= $Tag->getValue();
	
				$Tag->set($item->getValue(),"link");
				$link	= $Tag->getValue();
	
				$Tag->set($item->getValue(),"description");
				$description	= $Tag->getValue();		
	
				$this->addItem($title,$description,$link,$about);
			}
			return true;
		}
		return false;
	}
	
	function read(){		
		$titleTag		= new Tag("title",$this->getTitle());
		$linkTag			= new Tag("link",$this->getLink());
		$descriptionTag	= new Tag("description",$this->getDescription());
		$itemsTag		= new Tag("items");
		$seqTag			= new Tag("rdf:Seq");
		$seqValue		= "";

		foreach($this->itemList as $rdfItem){
			$rdfLinkTag = new Tag("rdf:li");
			$rdfLinkTag->addParameterValue("rdf:resource",$rdfItem->getLink());
			
			$seqValue .= $rdfLinkTag->get();
		}
		$seqTag->setValue($seqValue);
		$itemsTag->setValue($seqTag->get());

		$channelTag		= new Tag("channel");
		$channelValue	= "\n";
		$channelValue	.= $titleTag->get()."\n";
		$channelValue	.= $linkTag->get()."\n";
		$channelValue	.= $descriptionTag->get()."\n";
		$channelValue	.= $itemsTag->get()."\n";

		$channelTag->addParameterValue("rdf:about",$this->getAbout());	
		$channelTag->setValue($channelValue);			
		
		$rdfTag			= new Tag("rdf:RDF");
		$rdfValue		= "\n";
		$rdfValue		.= $channelTag->get()."\n";

		foreach($this->itemList as $rdfItem){
			$rdfValue .= $rdfItem->getTag()."\n";
		}

		$rdfTag->addParameterValue("xmlns","http://purl.org/rss/1.0/");
		$rdfTag->addParameterValue("xmlns:rdf","http://www.w3.org/1999/02/22-rdf-syntax-ns#");
		$rdfTag->addParameterValue("xmlns:content","http://purl.org/rss/1.0/modules/content/");
		$rdfTag->addParameterValue("xml:lang",$this->getLang());
		$rdfTag->setValue($rdfValue);

		$rtn	= "";
		$rtn	.= sprintf("<?xml version=\"1.0\" encoding=\"%s\" ?>\n",$this->getEncoding());
		$rtn	.= $rdfTag->get();
		
		return $rtn;
	}

	function addItem($title,$description="",$link="",$about=""){
		if(!is_array($this->itemList)){
			$this->itemList = array();
		}

		$rdfItem = new RdfItem($title,$description,$link,$about);
		$this->itemList[] = $rdfItem;
	}
	
	function write(){
		print($this->read());
	}

	function setLang($value){
		$this->lang = $value;
	}
	function getLang(){
		return $this->lang;
	}
	function setEncoding($value){
		$this->encoding = $value;
	}
	function getEncoding(){
		return $this->encoding;
	}
	function setAbout($value){
		$this->about = $value;
	}
	function getAbout(){
		return $this->about;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setLink($value){
		$this->link = $value;
	}
	function getLink(){
		return $this->link;
	}	
	function setDescription($value){
		$this->description = $value;
	}
	function getDescription(){
		return $this->description;
	}
	
	function getItemList(){
		return $this->itemList;
	}
}
?>