<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."test/Validate.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/System.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.1.3
 */
class RequestValidate extends Validate{
	var $errors	= array();
	var $request	= array();
	var $session	= array();	
	var $files	= array();
	var $post	= false;
	
	var $sessionExpire		= 2592000;	
	var $cacheLimiter		= "nocache";	/** @note (none/nocache/private/private_no_expire/public) */

	function RequestValidate($request=array()){
		$this->reset();

		session_cache_limiter($this->cacheLimiter);
		session_cache_expire($this->sessionExpire);

		if(is_array($_FILES)){
			foreach($_FILES as $key => $files){
				$this->files[$key] = $this->parseFileElement($files);
			}
		}
		if(is_array($_SESSION)){
			foreach($_SESSION as $key => $session){
				$this->session[$key] = Variable::getMagicQuotesOffValue($session);
			}
		}
		if(is_array($_COOKIE)){
			foreach($_COOKIE as $key => $cookie){
				$this->session[$key] = Variable::getMagicQuotesOffValue($cookie);
			}
		}
		if(is_array($_POST) && sizeof($_POST) > 0){
			$this->post = true;
			
			foreach($_POST as $key => $post){
				$this->request[$key] = Variable::getMagicQuotesOffValue($post);
			}
		}
		if(is_array($_GET)){
			foreach($_GET as $key => $get){
				$this->request[$key] = Variable::getMagicQuotesOffValue($get);
			}
		}
		if(is_array($request)){
			foreach($request as $key => $value){
				$this->request[$key] = Variable::getMagicQuotesOffValue($value);
			}
		}
		$this->validate();
	}

	function reset(){
	}
	function validate(){
	}
	function isPost(){
		return $this->post;
	}
	function setError($error){
		$this->request["errors"][] = $error;
	}
	function getErrors(){
		return $this->errors;
	}
	function isError(){
		if(is_array($this->errors) && sizeof($this->errors) > 0){
			return true;
		}
		return false;
	}

	function isElement($elementName){
		return array_key_exists($elementName,$this->request);
	}
	function setElement($elementName,$element){
		$this->request[$elementName] = $element;
	}
	function getElement($elementName,$defaultData=""){
		if($this->request[$elementName] == null){
			return $defaultData;
		}
		return $this->request[$elementName];
	}
	function clearElement($elementName){
		if(is_array($elementName)){
			foreach($elementName as $name){
				unset($this->request[$name]);
			}
		}else{
			unset($this->request[$elementName]);
		}
	}
	function getElements(){
		return $this->request;
	}
	function clearElements(){
		$this->request = array();
	}

	function isSession($elementName){
		return array_key_exists($elementName,$this->session);
	}
	function setSession($elementName,$element){
		$this->session[$elementName] = $element;
	}
	function getSession($elementName,$defaultData=""){
		if($this->session[$elementName] == null){
			return $defaultData;
		}
		return $this->session[$elementName];
	}
	function clearSession($elementName){
		unset($this->session[$elementName]);
	}
	function getSessions(){
		return $this->session;
	}
	function clearSessions(){
		$this->session = array();
	}
	
	function getFiles(){
		return $this->files;
	}
	function getFile($elementName){
		return $this->files[$elementName];
	}

	function parseFileElement($requestFiles){
		$fileElement				= new File($requestFiles['name']);
		$fileElement->tmp		= $requestFiles['tmp_name'];
		$fileElement->size		= $requestFiles['size'];
		$fileElement->error		= $requestFiles['error'];

		return $fileElement;
	}
	function toObject(&$object){
		if(is_object($object)){
			$methodList = array();

			foreach(get_class_methods($object) as $methodName){
				if(preg_match("/^set(.+)$/i",$methodName,$setter)){
					$methodList[strtolower($setter[1])] = $methodName;
				}
			}
			foreach($this->getElements() as $key => $request){
				if(!empty($methodList[strtolower($key)])){
					call_user_func_array(array(&$object,$methodList[strtolower($key)]),array($request));
				}
			}
			return $object;
		}
		return false;
	}

	function parseObject($object){
		if(is_object($object)){
			$methodList	= array();
			$vars		= get_object_vars($object);

			foreach(get_class_methods($object) as $methodName){
				if(preg_match("/^get(.+)$/i",$methodName,$setter)){
					$methodList[strtolower($setter[1])] = $methodName;
				}
			}
			foreach($vars as $key => $value){
				if(isset($methodList[strtolower($key)])){
					$value = call_user_func_array(array(&$object,$methodList[strtolower($key)]),array());
				}
				$this->setElement($key,$value);
			}
		}
	}
	
}
?>