<?php
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version develop
 */
class Http{
	function get($url){
		$urlList		= parse_url($url);
		$port		= 80;
		$host		= $urlList["host"];
		$method		= "GET";
		$query		= "";
		$response	= "";
		
		if(empty($urlList["port"])){
			if($urlList["scheme"] == "ssl" || $urlList["scheme"] == "https"){
				$port = 443;
			}else{
				$port = 80;
			}
		}else{
				$port = $urlList["port"];
		}
		$fp	= fsockopen($host,$port,$errorno,$errormsg);

		if(!$fp){
			$logger = new Logger($this);
			$logger->warning(sprintf("network error %s (%s)",$errstr,$errno));
			
			return false;
		}
		if(isset($urlList["query"])){
			$urlList["query"] = sprintf("?%s",$urlList["query"]);
		}
		if(empty($urlList["path"])){
			$urlList["path"] = "/";
		}
		$query .= sprintf("%s %s%s HTTP/1.1\r\n",$method,$urlList["path"],$urlList["query"]);
		$query .= sprintf("Host: %s\r\n",$host);
		$query .= sprintf("User-Agent: %s\r\n",$_SERVER["HTTP_USER_AGENT"]);
		$query .= sprintf("Connection: Close\r\n\r\n");

		fwrite($fp,$query);
		while(!feof($fp)){
			$response .= fgets($fp,1024);
		}
		fclose($fp);

		list($head,$body)	= split("\r\n\r\n",$response,2);
		$redirectUrl			= array();
		$httpCode			= array();
		
		if(!empty($head)){
			if(preg_match("/HTTP\/.+[\040](\d\d\d)/i",$head,$httpCode)){
				if($httpCode[1] != "200"){
					if($httpCode[1] == "302"){
						if(preg_match("/Location:[\040](.*)/i",$head,$redirectUrl)){
							return $this->get($redirectUrl[1]);
						}
					}
					return false;
				}
			}
		}
		return $body;
	}
}
?>