<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/RequestValidate.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/TagUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/Tag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 1.0.0
 */
class BasicLoginRequestValidate extends RequestValidate{
	function BasicLoginRequestValidate($request=array()){
		parent::RequestValidate($request);

		if(!empty($_COOKIE[$this->_getSessionLoginName()])){
			session_id($_COOKIE[$this->_getSessionLoginName()]);
			session_regenerate_id();
		}
		session_start();
	}

	function invalidLoginForward($authFilename,$templateFileName="",$remotePath=""){
		if(!$this->_login($authFilename)){
			if(empty($templateFileName)){
				$templateFileName = Rhaco::resource("templates/login.html");
			}
			$login = $this->getElement("login");

			$this->clearElement(array("password","login"));
			$this->setElement("elements",$this->getElements());
			$this->setElement("requestUrl",$_SERVER["SCRIPT_URI"]);
			$this->setElement("login",$login);

			$htmlParser	= new HtmlParser();
			$htmlParser->setRequest($this->getElements());

			$htmlParser->clearCash($templateFileName);
			$htmlParser->write($templateFileName,$remotePath);

			exit;
		}
		return true;
	}
	function _login($authFilename=""){		
		if(isset($_SESSION[$this->_getSessionLoginName()])){
			return true;
		}
		if($this->isElement("login") && $this->isElement("password")){
			$tagUtil		= new TagUtil();

			if($tagUtil->isTagfile($authFilename,"auth")){
				$authTag		= new Tag("user");
				$authTag->addParameterValue("login",$this->getElement("login"));
				$authTag->addParameterValue("password",md5($this->getElement("password")));
	
				$user = $tagUtil->get($authFilename,$authTag);

				if($user != false){
					$_SESSION[$this->_getSessionLoginName()] = $user;
					return true;
				}
			}
		}
		return false;
	}
	function logout(){
		session_unregister($this->_getSessionLoginName());
		unset($_SESSION[$this->_getSessionLoginName()]);
	}
	function getLoginUser(){
		if($this->login()){
			return $_SESSION[$this->_getSessionLoginName()];
		}
		return null;
	}
	function addLoginUser($authFilename,$login,$password,$value=""){
		if(!empty($login) && !empty($password)){
			$tagUtil		= new TagUtil();
			
			if($tagUtil->isTagfile($authFilename,"auth",true)){
				$tag = new Tag("user");
				$tag->addParameterValue("login",$login);

				foreach($tagUtil->select($authFilename,$tag) as $user){
					return false;
				}
				$tag->addParameterValue("password",md5($password));
				$tag->addValue($value);

				return $tagUtil->insert($authFilename,$tag);
			}
		}
		return false;
	}
	function _getSessionLoginName(){
		if(defined("REQUEST_SESSION_LOGIN_NAME")){
			return constant("REQUEST_SESSION_LOGIN_NAME");
		}
		return "LOGIN";
	}
}
?>