<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."util/Logger.php");
/**
 * @author Kazutaka Tokushima
 * @license LGPL
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.8.2
 */
class Url{
	function parse($src,$remotePath){
		$get		= array();
		$parse	= array();
		$rep		= array();

		if(!empty($remotePath)){
			$urlParentList	= array();
			$parseObject		= array();

			$urlList			= parse_url($remotePath);
			$rootScheme		= $urlList["scheme"];
			$rootPort		= $urlList["port"];
			$rootHost 		= $urlList["host"];

			if(empty($rootHost)){
				$rootHost = $_SERVER["HTTP_HOST"];
			}
			if(empty($rootScheme)){
				$rootScheme = "http";
			}

			$pathArray = split("/",$urlList["path"]);

			$urlParentSize = 0;
			foreach($pathArray as $value){
				if(!empty($value) && false === strpos($value,".")){
					$urlParentList[$urlParentSize] = $value;
					$urlParentSize++;
				}
			}
			if(preg_match_all("/(<[\s]*([a-z]+)[\s]+[^>]+?>)/i",$src,$rep)){
				foreach($rep[1] as $tagKey => $tag){
					$tagName		= strtolower($rep[2][$tagKey]);
					$name		= "";
					$type		= "";
					$path		= "";
					$scheme		= "";

					if(preg_match_all("/[\s](href|src|value|action|background|name|type|scheme)[\s]*=[\s]*([\"\'])([^\\2]+?)\\2/i",$tag,$parse)){
						foreach($parse[1] as $key => $target){
							$parameter = strtolower($target);

							if($parameter == "name"){
								$name	= $parse[3][$key];
							}else if($parameter == "type"){
								$type	= $parse[3][$key];
							}else if($parameter == "scheme"){
								$scheme	= $parse[3][$key];
							}else{
								$path	= $parse[3][$key];
							}
						}
					}
					if(!empty($path)){
						if($tagName == "param" || $tagName == "input" || $tagName == "option"){
							if(!(
								($tagName == "param" && $name == "movie") ||
								($tagName == "input" && $type == "image")
							)){
								$path = "";
							}
						}
						if(!empty($path)){
							$parseObject[$tag]["path"]	= $path;
							$parseObject[$tag]["scheme"]	= $scheme;
						}
					}
				}
			}
			if(preg_match_all("/(location\.href[\s]*=[\s]*([\"\'])([^\\2]*?)\\2)/i",$src,$get)){
				foreach($get[0] as $key => $value){
					if(!empty($get[3][$key])){
						$parseObject[$get[0][$key]]["path"] = $get[3][$key];
					}
				}
			}
			if(preg_match_all("/(window\.open\([\s]*([\"\'])([^\\2]*?)\\2)/i",$src,$get)){
				foreach($get[0] as $key => $value){
					if(!empty($get[3][$key])){
						$parseObject[$get[0][$key]]["path"] = $get[3][$key];
					}
				}
			}
			if(!empty($parseObject)){
				foreach($parseObject as $tag => $object){
					if(!preg_match("/(javascript:)|(^[^\?]+:\/\/)/i",$object["path"])){
						$path = "";

						if("/" != substr($object["path"],0,1)){
							$pathSplit	= split("/",$object["path"]);
							$pathList	= $urlParentList;
							$pathSize	= sizeof($urlParentList) - 1;

							foreach($pathSplit as $pathStr){
								if($pathStr == "."){
								}else if($pathStr == ".."){
									$pathSize -= 1;
								}else{
									$pathSize += 1;
									$pathList[$pathSize] = $pathStr;
								}
							}
							for($i=0;$i<=$pathSize;$i++){
								$path .= "/".$pathList[$i];
							}
						}
						if(empty($path)){
							$path = $object["path"];
						}
						if(!empty($object["scheme"])){
							$absolute	= sprintf("%s://%s",$object["scheme"],$rootHost);
						}else{
							$absolute	= sprintf("%s://%s",$rootScheme,$rootHost);

							if(!empty($rootPort)){
								$absolute = sprintf("%s:%s",$absolute,$rootPort);
							}
						}
						$absolute	= $absolute.$path;
						$absolute	= str_replace($object["path"],$absolute,$tag);
						$src			= str_replace($tag,$absolute,$src);
					}
				}
			}
		}
		return $src;
	}

	function parseAbsolute($baseUrl,$targetUrl){
		$baseUrl		= str_replace("\\","/",$baseUrl);
		$targetUrl	= str_replace("\\","/",$targetUrl);
		$basedir		= "";
		$targetdir	= "";
		$basescheme	= "";
		
		if(empty($baseUrl) || preg_match("/^\//",$targetUrl) || preg_match("/^\w\:/",$targetUrl)){
			return $targetUrl;
		}
		if(preg_match("/^(.+\/)[^\/]+\.[^\/]+$/",$baseUrl,$null)){
			$baseUrl = $null[1];
		}
		if(preg_match("/([\w]+:\/\/)(.+)/",$baseUrl,$null)){
			$basescheme = $null[1];
			$baseUrl = $null[2];
		}
		$upperCount	= substr_count($targetUrl,"../");
		$baseList	= split("/",$baseUrl);
		$targetList	= split("/",$targetUrl);

		for($i=0;$i<sizeof($baseList)-$upperCount;$i++){
			if(!empty($baseList[$i])){
				$basedir .= $baseList[$i]."/";
			}			
		}
		for($i=0;$i<sizeof($targetList);$i++){
			if(!empty($targetList[$i]) && !preg_match("/^[\.]+$/",$targetList[$i])){
				$targetdir .= $targetList[$i]."/";
			}			
		}
		if(!empty($basescheme)){
			$basedir = sprintf("%s%s",$basescheme,$basedir);
		}else if(substr($basedir,0,1) != "/" && !preg_match("/^[\w]+\:/",$basedir)){
			$basedir = "/".$basedir;
		}
		return sprintf("%s%s",$basedir,substr($targetdir,0,-1));
	}

	/**
	 * @create 20041028
	 */	
	function parseRelative($baseUrl,$targetUrl){
		$baseUrl		= str_replace("\\","/",$baseUrl);
		$targetUrl	= str_replace("\\","/",$targetUrl);
		$filename		= "";
				
		if(preg_match("/^(.+)\/([^\/]+\.[^\/]+)$/",$targetUrl,$null)){
			$targetUrl	= $null[1]."/";
			$filename	= $null[2];
		}
		if(preg_match(sprintf("/^%s(.+)$/",preg_quote($baseUrl,"/")),$targetUrl,$null)){
			$count = substr_count($null[1],"/");

			for($i=0;$i<$count;$i++){
				$filename = sprintf("../%s",$filename);
			}
		}else{
			$filename = sprintf("./%s",$filename);
		}
		return $filename;
	}
}
?>